/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Contributor;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Maintainer;
import org.openrewrite.Option;
import org.openrewrite.PolyglotExport;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.NullUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.scheduling.ForkJoinScheduler;
import org.openrewrite.table.RecipeRunStats;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
@PolyglotExport(typeScript="Recipe", llvm="Recipe")
public abstract class Recipe
implements Cloneable {
    public static final String PANIC = "__AHHH_PANIC!!!__";
    private static final Logger logger = LoggerFactory.getLogger(Recipe.class);
    public static final TreeVisitor<?, ExecutionContext> NOOP = new TreeVisitor<Tree, ExecutionContext>(){

        @Override
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return tree;
        }
    };
    private transient List<Recipe> singleSourceApplicableTests;
    private transient List<Recipe> applicableTests;
    private transient RecipeDescriptor descriptor;
    @Nullable
    private transient List<DataTableDescriptor> dataTables;
    private static final List<DataTableDescriptor> GLOBAL_DATA_TABLES = Arrays.asList(RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(new SourcesFileResults(Recipe.noop())), RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(new SourcesFileErrors(Recipe.noop())), RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(new RecipeRunStats(Recipe.noop())));
    protected List<Contributor> contributors;
    protected transient List<RecipeExample> examples;
    @JsonIgnore
    private final List<Recipe> recipeList = new CopyOnWriteArrayList<Recipe>();

    @JsonProperty(value="@c")
    public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    public static Recipe noop() {
        return new Noop();
    }

    @Language(value="markdown")
    public abstract String getDisplayName();

    @Language(value="markdown")
    public String getDescription() {
        return "";
    }

    public Set<String> getTags() {
        return Collections.emptySet();
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public final RecipeDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.createRecipeDescriptor();
        }
        return this.descriptor;
    }

    protected RecipeDescriptor createRecipeDescriptor() {
        URI recipeSource;
        List<OptionDescriptor> options = this.getOptionDescriptors(this.getClass());
        ArrayList<RecipeDescriptor> recipeList1 = new ArrayList<RecipeDescriptor>();
        for (Recipe next : this.getRecipeList()) {
            recipeList1.add(next.getDescriptor());
        }
        try {
            recipeSource = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return new RecipeDescriptor(this.getName(), this.getDisplayName(), this.getDescription(), this.getTags(), this.getEstimatedEffortPerOccurrence(), options, this.getLanguages(), recipeList1, this.getDataTableDescriptors(), this.getMaintainers(), this.getContributors(), this.getExamples(), recipeSource);
    }

    private List<OptionDescriptor> getOptionDescriptors(Class<?> recipeClass) {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        for (Field field : recipeClass.getDeclaredFields()) {
            Object value;
            try {
                field.setAccessible(true);
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                value = null;
            }
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            options.add(new OptionDescriptor(field.getName(), field.getType().getSimpleName(), option.displayName(), option.description(), option.example().isEmpty() ? null : option.example(), (List<String>)(option.valid().length == 1 && option.valid()[0].isEmpty() ? null : Arrays.asList(option.valid())), option.required(), value));
        }
        return options;
    }

    public List<DataTableDescriptor> getDataTableDescriptors() {
        return ListUtils.concatAll(this.dataTables == null ? Collections.emptyList() : this.dataTables, GLOBAL_DATA_TABLES);
    }

    @Deprecated
    public List<String> getLanguages() {
        return Collections.emptyList();
    }

    public List<Maintainer> getMaintainers() {
        return new ArrayList<Maintainer>();
    }

    public List<Contributor> getContributors() {
        if (this.contributors == null) {
            return new ArrayList<Contributor>();
        }
        return this.contributors;
    }

    public List<RecipeExample> getExamples() {
        if (this.examples == null) {
            return new ArrayList<RecipeExample>();
        }
        return this.examples;
    }

    @Incubating(since="7.3.0")
    public boolean causesAnotherCycle() {
        return this.recipeList.stream().anyMatch(Recipe::causesAnotherCycle);
    }

    public Recipe doNext(Recipe recipe) {
        if (recipe == this) {
            throw new IllegalArgumentException("Cannot add a recipe to itself.");
        }
        this.recipeList.add(recipe);
        this.descriptor = null;
        return this;
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return NOOP;
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return null;
    }

    public Recipe addApplicableTest(TreeVisitor<?, ExecutionContext> test) {
        return this.addApplicableTest(AdHocRecipe.fromNullableVisitor("Add applicable test for: " + this.getDisplayName(), "Add applicable test for: " + this.getDescription(), test));
    }

    public Recipe addApplicableTest(Recipe test) {
        if (this.applicableTests == null) {
            this.applicableTests = new ArrayList<Recipe>(1);
        }
        this.applicableTests.add(test);
        return this;
    }

    public void addDataTable(DataTable<?> dataTable) {
        if (this.dataTables == null) {
            this.dataTables = new ArrayList<DataTableDescriptor>();
        }
        this.dataTables.add(RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(dataTable));
    }

    public List<Recipe> getApplicableTests() {
        List<Recipe> tests = ListUtils.concat(AdHocRecipe.fromNullableVisitor("Applicable test for: " + this.getDisplayName(), "Applicable test for: " + this.getDescription(), this.getApplicableTest()), this.applicableTests);
        return tests == null ? Collections.emptyList() : tests;
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return null;
    }

    public Recipe addSingleSourceApplicableTest(TreeVisitor<?, ExecutionContext> test) {
        return this.addSingleSourceApplicableTest(AdHocRecipe.fromNullableVisitor("Add single source applicable test for: " + this.getDisplayName(), "Add single source applicable test for: " + this.getDescription(), test));
    }

    public Recipe addSingleSourceApplicableTest(Recipe test) {
        if (this.singleSourceApplicableTests == null) {
            this.singleSourceApplicableTests = new ArrayList<Recipe>(1);
        }
        this.singleSourceApplicableTests.add(test);
        return this;
    }

    public List<Recipe> getSingleSourceApplicableTests() {
        List<Recipe> tests = ListUtils.concat(AdHocRecipe.fromNullableVisitor("Single Source Applicable test for: " + this.getDisplayName(), "Single Source Applicable test for: " + this.getDescription(), this.getSingleSourceApplicableTest()), this.singleSourceApplicableTests);
        return tests == null ? Collections.emptyList() : tests;
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return before;
    }

    public final RecipeRun run(List<? extends SourceFile> before) {
        return this.run(before, new InMemoryExecutionContext());
    }

    public final RecipeRun run(List<? extends SourceFile> before, ExecutionContext ctx) {
        return this.run(before, ctx, 3);
    }

    public final RecipeRun run(List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles) {
        return this.run(before, ctx, ForkJoinScheduler.common(), maxCycles, 1);
    }

    public final RecipeRun run(List<? extends SourceFile> before, ExecutionContext ctx, RecipeScheduler recipeScheduler, int maxCycles, int minCycles) {
        return recipeScheduler.scheduleRun(this, before, ctx, maxCycles, minCycles);
    }

    public Validated validate(ExecutionContext ctx) {
        Validated validated = this.validate();
        for (Recipe recipe : this.recipeList) {
            validated = validated.and(recipe.validate(ctx));
        }
        return validated;
    }

    public Validated validate() {
        Validated validated = Validated.none();
        List<Field> requiredFields = NullUtils.findNonNullFields(this.getClass());
        for (Field field : requiredFields) {
            try {
                validated = validated.and(Validated.required(field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Unable to validate the field [{}] on the class [{}]", (Object)field.getName(), (Object)this.getClass().getName());
            }
        }
        for (Recipe recipe : this.recipeList) {
            validated = validated.and(recipe.validate());
        }
        return validated;
    }

    @Incubating(since="7.0.0")
    public final Collection<Validated> validateAll(ExecutionContext ctx) {
        return this.validateAll(ctx, new ArrayList<Validated>());
    }

    public final Collection<Validated> validateAll() {
        return this.validateAll(new InMemoryExecutionContext(), new ArrayList<Validated>());
    }

    private Collection<Validated> validateAll(ExecutionContext ctx, Collection<Validated> acc) {
        acc.add(this.validate(ctx));
        for (Recipe recipe : this.recipeList) {
            recipe.validateAll(ctx, acc);
        }
        return acc;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    public void setExamples(List<RecipeExample> examples) {
        this.examples = examples;
    }

    static class Noop
    extends Recipe {
        Noop() {
        }

        @Override
        public String getDisplayName() {
            return "Do nothing";
        }

        @Override
        public String getDescription() {
            return "Default no-op test, does nothing.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return NOOP;
        }
    }

    private static final class AdHocRecipe
    extends Recipe {
        @Language(value="markdown")
        private final String displayName;
        @Language(value="markdown")
        private final String description;
        private final TreeVisitor<?, ExecutionContext> visitor;

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return this.visitor;
        }

        @Nullable
        static AdHocRecipe fromNullableVisitor(@Language(value="markdown") String displayName, @Language(value="markdown") String description, @Nullable TreeVisitor<?, ExecutionContext> visitor) {
            return visitor == null ? null : new AdHocRecipe(displayName, description, visitor);
        }

        public AdHocRecipe(@Language(value="markdown") String displayName, @Language(value="markdown") String description, TreeVisitor<?, ExecutionContext> visitor) {
            this.displayName = displayName;
            this.description = description;
            this.visitor = visitor;
        }

        @NonNull
        public String toString() {
            return "Recipe.AdHocRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", visitor=" + this.getVisitor() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdHocRecipe)) {
                return false;
            }
            AdHocRecipe other = (AdHocRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            TreeVisitor<?, ExecutionContext> this$visitor = this.getVisitor();
            TreeVisitor<?, ExecutionContext> other$visitor = other.getVisitor();
            return !(this$visitor == null ? other$visitor != null : !this$visitor.equals(other$visitor));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AdHocRecipe;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            TreeVisitor<?, ExecutionContext> $visitor = this.getVisitor();
            result = result * 59 + ($visitor == null ? 43 : $visitor.hashCode());
            return result;
        }
    }
}

