/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class FindAndReplace
extends Recipe {
    @Option(displayName="Find", description="The text to find (and replace).", example="blacklist")
    private final String find;
    @Option(displayName="Replace", description="The replacement text for `find`.", example="denylist")
    private final String replace;
    @Option(displayName="Regex", description="Default false. If true, `find` will be interpreted as a Regular Expression, and capture group contents will be available in `replace`.", required=false)
    @Nullable
    private final Boolean regex;
    @Option(displayName="Optional file Matcher", description="Matching files will be modified. This is a glob expression.", example="foo/bar/baz.txt", required=false)
    @Nullable
    @Deprecated
    private final String fileMatcher;

    @Override
    public String getDisplayName() {
        return "Find and replace";
    }

    @Override
    public String getDescription() {
        return "Simple text find and replace. When the original source file is a language-specific Lossless Semantic Tree, this operation irreversibly converts the source file to a plain text file. Subsequent recipes will not be able to operate on language-specific type.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath<ExecutionContext>(this.fileMatcher);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext executionContext) {
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText text = PlainTextParser.convert(sourceFile);
                String newText = Boolean.TRUE.equals(FindAndReplace.this.regex) ? text.getText().replaceAll(FindAndReplace.this.find, FindAndReplace.this.replace) : text.getText().replace(FindAndReplace.this.find, FindAndReplace.this.replace);
                return text.getText().equals(newText) ? text : text.withText(newText);
            }
        };
    }

    public FindAndReplace(String find, String replace, @Nullable Boolean regex, @Nullable String fileMatcher) {
        this.find = find;
        this.replace = replace;
        this.regex = regex;
        this.fileMatcher = fileMatcher;
    }

    public String getFind() {
        return this.find;
    }

    public String getReplace() {
        return this.replace;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @Deprecated
    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "FindAndReplace(find=" + this.getFind() + ", replace=" + this.getReplace() + ", regex=" + this.getRegex() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAndReplace)) {
            return false;
        }
        FindAndReplace other = (FindAndReplace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        String this$replace = this.getReplace();
        String other$replace = other.getReplace();
        if (this$replace == null ? other$replace != null : !this$replace.equals(other$replace)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindAndReplace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        String $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : $replace.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

