/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.UUID;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class Range
implements Marker {
    private final UUID id;
    private final Position start;
    private final Position end;

    public int length() {
        return this.end.offset - this.start.offset;
    }

    public Range(UUID id, Position start, Position end) {
        this.id = id;
        this.start = start;
        this.end = end;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Position this$start = this.getStart();
        Position other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Position this$end = this.getEnd();
        Position other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Position $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Position $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "Range(id=" + this.getId() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }

    @NonNull
    public Range withId(UUID id) {
        return this.id == id ? this : new Range(id, this.start, this.end);
    }

    @NonNull
    public Range withStart(Position start) {
        return this.start == start ? this : new Range(this.id, start, this.end);
    }

    @NonNull
    public Range withEnd(Position end) {
        return this.end == end ? this : new Range(this.id, this.start, end);
    }

    public static final class Position {
        private final int offset;
        private final int line;
        private final int column;

        public Position(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Position)) {
                return false;
            }
            Position other = (Position)o;
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.getLine() != other.getLine()) {
                return false;
            }
            return this.getColumn() == other.getColumn();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOffset();
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            return result;
        }

        @NonNull
        public String toString() {
            return "Range.Position(offset=" + this.getOffset() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ")";
        }

        @NonNull
        public Position withOffset(int offset) {
            return this.offset == offset ? this : new Position(offset, this.line, this.column);
        }

        @NonNull
        public Position withLine(int line) {
            return this.line == line ? this : new Position(this.offset, line, this.column);
        }

        @NonNull
        public Position withColumn(int column) {
            return this.column == column ? this : new Position(this.offset, this.line, column);
        }
    }
}

