/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRunStats;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.table.SourcesFileResults;
import org.openrewrite.text.PlainTextParser;

class RecipeSchedulerUtils {
    RecipeSchedulerUtils() {
    }

    static List<Result> createAndProcessResults(List<? extends SourceFile> before, List<? extends SourceFile> after, ExecutionContext ctx, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile) {
        HashMap<UUID, SourceFile> sourceFileIdentities = new HashMap<UUID, SourceFile>();
        for (SourceFile sourceFile : before) {
            sourceFileIdentities.put(sourceFile.getId(), sourceFile);
        }
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile : after) {
            SourceFile sourceFile2 = (SourceFile)sourceFileIdentities.get(sourceFile.getId());
            if (sourceFile2 == sourceFile) continue;
            if (sourceFile2 == null) {
                results.add(new Result(null, sourceFile, Collections.singletonList(recipeThatAddedOrDeletedSourceFile.get(sourceFile.getId()))));
                continue;
            }
            if (sourceFile2.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile2, sourceFile, sourceFile.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change")).getRecipes()));
        }
        Set set = after.stream().map(Tree::getId).collect(Collectors.toSet());
        for (SourceFile sourceFile : before) {
            if (set.contains(sourceFile.getId()) || sourceFile.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile, null, Collections.singleton(recipeThatAddedOrDeletedSourceFile.get(sourceFile.getId()))));
        }
        for (Result result : results) {
            SourcesFileResults resultsTable = new SourcesFileResults(Recipe.noop());
            Stack<RecipeDescriptor[]> recipeStack = new Stack<RecipeDescriptor[]>();
            for (RecipeDescriptor rd : result.getRecipeDescriptorsThatMadeChanges()) {
                recipeStack.push(new RecipeDescriptor[]{null, rd});
            }
            while (!recipeStack.isEmpty()) {
                RecipeDescriptor[] recipeThatMadeChange = (RecipeDescriptor[])recipeStack.pop();
                resultsTable.insertRow(ctx, new SourcesFileResults.Row(result.getBefore() == null ? "" : result.getBefore().getSourcePath().toString(), result.getAfter() == null ? "" : result.getAfter().getSourcePath().toString(), recipeThatMadeChange[0] == null ? "" : recipeThatMadeChange[0].getName(), recipeThatMadeChange[1].getName()));
                for (RecipeDescriptor rd : recipeThatMadeChange[1].getRecipeList()) {
                    recipeStack.push(new RecipeDescriptor[]{recipeThatMadeChange[1], rd});
                }
            }
        }
        return results;
    }

    public static <S extends SourceFile> S addRecipesThatMadeChanges(Stack<Recipe> recipeStack, S afterFile) {
        return (S)((SourceFile)afterFile.withMarkers(afterFile.getMarkers().computeByType(RecipesThatMadeChanges.create(recipeStack), (r1, r2) -> {
            r1.getRecipes().addAll(r2.getRecipes());
            return r1;
        })));
    }

    public static <S extends SourceFile> List<S> handleUncaughtException(Stack<Recipe> recipeStack, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile, List<S> before, ExecutionContext ctx, Recipe recipe, Throwable t) {
        RecipeRunException vt;
        List<S> exceptionMapped;
        ctx.getOnError().accept(t);
        ctx.putMessage("__AHHH_PANIC!!!__", true);
        if (t instanceof RecipeRunException && (exceptionMapped = ListUtils.map(before, arg_0 -> RecipeSchedulerUtils.lambda$handleUncaughtException$2(vt = (RecipeRunException)t, recipeStack, arg_0))) != before) {
            return exceptionMapped;
        }
        Object exception = ((SourceFile)PlainTextParser.builder().build().parse("Rewrite encountered an uncaught recipe error in " + recipe.getName() + ".").get(0)).withSourcePath(Paths.get("recipe-exception-" + ctx.incrementAndGetUncaughtExceptionCount() + ".txt", new String[0]));
        exception = (SourceFile)Markup.error(exception, t);
        recipeThatAddedOrDeletedSourceFile.put(exception.getId(), recipeStack);
        return ListUtils.concat(before, exception);
    }

    static <S extends SourceFile> boolean testAllApplicableTestsMatchSourceFile(S s, List<Recipe> applicableTests, RecipeRunStats runStats, RecipeScheduler recipeScheduler, Stack<Recipe> recipeStack, ExecutionContext ctx) {
        List<S> sList = Collections.singletonList(s);
        boolean allMatch = true;
        for (Recipe applicableTest : applicableTests) {
            RecipeRunStats nextStats = runStats.addCalledRecipe(applicableTest);
            Stack<Recipe> stack = new Stack<Recipe>();
            stack.addAll(recipeStack);
            stack.push(applicableTest);
            Recipe previousParent = ctx.putParentRecipe(recipeStack.peek());
            List<S> next = recipeScheduler.scheduleVisit(nextStats, stack, sList, ctx, null, new HashMap<UUID, Stack<Recipe>>());
            ctx.putParentRecipe(previousParent);
            if (sList == next) {
                allMatch = false;
                break;
            }
            for (S newS : next) {
                newS.getMarkers().findFirst(Markup.Error.class).ifPresent(m -> {
                    if (m.getException() instanceof RecipeRunException) {
                        throw (RecipeRunException)m.getException();
                    }
                    throw new RuntimeException("Applicable Test Failed", m.getException());
                });
            }
        }
        return allMatch;
    }

    private static /* synthetic */ SourceFile lambda$handleUncaughtException$2(RecipeRunException vt, Stack recipeStack, SourceFile sourceFile) {
        SourceFile afterFile = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(sourceFile), 0);
        if (afterFile != sourceFile) {
            afterFile = RecipeSchedulerUtils.addRecipesThatMadeChanges(recipeStack, afterFile);
        }
        return afterFile;
    }
}

