/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tree;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParsingEventListener;

public class ParsingExecutionContextView
extends DelegatingExecutionContext {
    private static final String PARSING_LISTENER = "org.openrewrite.core.parsingListener";
    private static final String CHARSET = "org.openrewrite.parser.charset";
    private static final String PARSING_FAILURES = "org.openrewrite.core.parsingFailures";

    public ParsingExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static ParsingExecutionContextView view(ExecutionContext ctx) {
        if (ctx instanceof ParsingExecutionContextView) {
            return (ParsingExecutionContextView)ctx;
        }
        return new ParsingExecutionContextView(ctx);
    }

    public ParsingExecutionContextView setParsingListener(ParsingEventListener listener) {
        this.putMessage(PARSING_LISTENER, listener);
        return this;
    }

    public ParsingEventListener getParsingListener() {
        return this.getMessage(PARSING_LISTENER, ParsingEventListener.NOOP);
    }

    public ParsingExecutionContextView parseFailure(Parser.Input input, @Nullable Path relativeTo, Parser<?> parser, Throwable t) {
        PlainText pt = new PlainText(Tree.randomId(), input.getRelativePath(relativeTo), Markers.EMPTY, null, false, null, null, input.getSource(this).readFully());
        return this.parseFailure(pt, parser, t);
    }

    public ParsingExecutionContextView parseFailure(PlainText raw, Parser<?> parser, Throwable t) {
        this.putMessageInCollection(PARSING_FAILURES, raw.withMarkers(raw.getMarkers().addIfAbsent(ParseExceptionResult.build(parser, t))), ArrayList::new);
        return this;
    }

    public List<PlainText> getParseFailures() {
        return this.getMessage(PARSING_FAILURES, Collections.emptyList());
    }

    public List<PlainText> pollParseFailures() {
        return this.pollMessage(PARSING_FAILURES, Collections.emptyList());
    }

    public ParsingExecutionContextView setCharset(@Nullable Charset charset) {
        this.putMessage(CHARSET, charset);
        return this;
    }

    @Nullable
    public Charset getCharset() {
        return (Charset)this.getMessage(CHARSET);
    }
}

