/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Scanner;
import java.util.regex.Matcher;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.VersionComparator;

public class LatestRelease
implements VersionComparator {
    @Nullable
    private final String metadataPattern;

    public LatestRelease(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        Matcher matcher = VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(version));
        if (!matcher.matches() || PRE_RELEASE_ENDING.matcher(version).find()) {
            return false;
        }
        boolean requireMeta = !StringUtils.isNullOrEmpty(this.metadataPattern);
        String versionMeta = matcher.group(6);
        if (requireMeta) {
            return versionMeta != null && versionMeta.matches(this.metadataPattern);
        }
        return versionMeta == null;
    }

    static String normalizeVersion(String version) {
        if (version.endsWith(".RELEASE")) {
            return version.substring(0, version.length() - ".RELEASE".length());
        }
        if (version.endsWith(".FINAL") || version.endsWith(".Final")) {
            return version.substring(0, version.length() - ".FINAL".length());
        }
        long versionParts = LatestRelease.countVersionParts(version);
        if (versionParts <= 2L) {
            String[] versionAndMetadata = version.split("(?=[-+])");
            while (versionParts <= 2L) {
                versionAndMetadata[0] = versionAndMetadata[0] + ".0";
                ++versionParts;
            }
            version = versionAndMetadata[0] + (versionAndMetadata.length > 1 ? versionAndMetadata[1] : "");
        }
        return version;
    }

    static long countVersionParts(String version) {
        String part;
        long count = 0L;
        Scanner scanner = new Scanner(version);
        scanner.useDelimiter("[.\\-$]");
        while (scanner.hasNext() && !(part = scanner.next()).isEmpty() && Character.isDigit(part.charAt(0))) {
            ++count;
        }
        return count;
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        int i;
        StringBuilder nv1 = new StringBuilder(LatestRelease.normalizeVersion(v1));
        StringBuilder nv2 = new StringBuilder(LatestRelease.normalizeVersion(v2));
        long vp1 = LatestRelease.countVersionParts(nv1.toString());
        long vp2 = LatestRelease.countVersionParts(nv2.toString());
        long abs = Math.abs(vp1 - vp2);
        if (vp1 > vp2) {
            i = 1;
            while ((long)i <= abs) {
                nv2.append(".0");
                ++i;
            }
        } else if (vp2 > vp1) {
            i = 1;
            while ((long)i <= abs) {
                nv1.append(".0");
                ++i;
            }
        }
        Matcher v1Gav = VersionComparator.RELEASE_PATTERN.matcher(nv1.toString());
        Matcher v2Gav = VersionComparator.RELEASE_PATTERN.matcher(nv2.toString());
        v1Gav.matches();
        v2Gav.matches();
        String normalized1 = this.metadataPattern == null ? nv1.toString() : nv1.toString().replace(this.metadataPattern, "");
        String normalized2 = this.metadataPattern == null ? nv2.toString() : nv1.toString().replace(this.metadataPattern, "");
        try {
            int i2 = 1;
            while ((long)i2 <= Math.max(vp1, vp2)) {
                String v1Part = v1Gav.group(i2);
                String v2Part = v2Gav.group(i2);
                if (v1Part == null) {
                    return v2Part == null ? normalized1.compareTo(normalized2) : -1;
                }
                if (v2Part == null) {
                    return 1;
                }
                int diff = Integer.parseInt(v1Part) - Integer.parseInt(v2Part);
                if (diff != 0) {
                    return diff;
                }
                ++i2;
            }
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException("Illegal state while comparing versions : [" + nv1 + "] and [" + nv2 + "]. Metadata = [" + this.metadataPattern + "]");
        }
        return normalized1.compareTo(normalized2);
    }

    public static Validated build(String toVersion, @Nullable String metadataPattern) {
        return "latest.release".equalsIgnoreCase(toVersion) ? Validated.valid("latestRelease", new LatestRelease(metadataPattern)) : Validated.invalid("latestRelease", toVersion, "not latest release");
    }
}

