/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.artifacts;

import java.util.Objects;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class ContainerImage {
    @Nullable
    String repository;
    @Nullable
    String image;
    @Nullable
    String tag;
    @Nullable
    String digest;

    public ContainerImage(@Nullable String repository, @Nullable String image, @Nullable String tag, @Nullable String digest) {
        this.repository = repository;
        this.image = image;
        this.tag = tag;
        this.digest = digest;
    }

    public static ContainerImage parseImageName(String imageName) {
        String repository = null;
        String image = imageName;
        String tag = null;
        String digest = null;
        int idx = imageName.lastIndexOf(64);
        if (idx > -1) {
            digest = imageName.substring(idx + 1);
            imageName = imageName.substring(0, idx);
        }
        if ((idx = imageName.lastIndexOf(58)) > -1) {
            image = imageName.substring(0, idx);
            tag = imageName.substring(idx + 1);
            imageName = imageName.substring(0, idx);
        }
        if ((idx = imageName.lastIndexOf(47)) > -1) {
            image = imageName.substring(idx + 1);
            String s = imageName.substring(0, idx);
            if (!StringUtils.isNullOrEmpty(s)) {
                repository = s;
            }
        }
        return new ContainerImage(repository, image, tag, digest);
    }

    public boolean matches(ContainerImage otherName) {
        boolean matchesRepo = this.getRepository() == null && otherName.getRepository() == null || Objects.equals(this.getRepository(), otherName.getRepository()) || StringUtils.matchesGlob(this.getRepository(), otherName.getRepository());
        boolean matchesImage = this.getImage() == null && otherName.getImage() == null || Objects.equals(this.getImage(), otherName.getImage()) || StringUtils.matchesGlob(this.getImage(), otherName.getImage());
        boolean matchesTag = this.getTag() == null && otherName.getTag() == null || Objects.equals(this.getTag(), otherName.getTag()) || StringUtils.matchesGlob(this.getTag(), otherName.getTag());
        boolean matchesDigest = this.getDigest() == null && otherName.getDigest() == null || Objects.equals(this.getDigest(), otherName.getDigest()) || StringUtils.matchesGlob(this.getDigest(), otherName.getDigest());
        return matchesRepo && matchesImage && matchesTag && matchesDigest;
    }

    public boolean hasRepository() {
        return !StringUtils.isNullOrEmpty(this.repository);
    }

    public boolean hasImage() {
        return !StringUtils.isNullOrEmpty(this.image);
    }

    public boolean hasTag() {
        return !StringUtils.isNullOrEmpty(this.tag);
    }

    public boolean hasDigest() {
        return !StringUtils.isNullOrEmpty(this.digest);
    }

    public String toString() {
        String s = "";
        if (!StringUtils.isNullOrEmpty(this.repository)) {
            s = s + this.repository + "/";
        }
        s = s + this.image;
        if (!StringUtils.isNullOrEmpty(this.tag)) {
            s = s + ":" + this.tag;
        }
        if (!StringUtils.isNullOrEmpty(this.digest) && !"*".equals(this.digest)) {
            s = s + "@" + this.digest;
        }
        return s;
    }

    @Nullable
    public String getRepository() {
        return this.repository;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public String getDigest() {
        return this.digest;
    }

    public void setRepository(@Nullable String repository) {
        this.repository = repository;
    }

    public void setImage(@Nullable String image) {
        this.image = image;
    }

    public void setTag(@Nullable String tag) {
        this.tag = tag;
    }

    public void setDigest(@Nullable String digest) {
        this.digest = digest;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerImage)) {
            return false;
        }
        ContainerImage other = (ContainerImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        return !(this$digest == null ? other$digest != null : !this$digest.equals(other$digest));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ContainerImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        return result;
    }

    @NonNull
    public ContainerImage withRepository(@Nullable String repository) {
        return this.repository == repository ? this : new ContainerImage(repository, this.image, this.tag, this.digest);
    }

    @NonNull
    public ContainerImage withImage(@Nullable String image) {
        return this.image == image ? this : new ContainerImage(this.repository, image, this.tag, this.digest);
    }

    @NonNull
    public ContainerImage withTag(@Nullable String tag) {
        return this.tag == tag ? this : new ContainerImage(this.repository, this.image, tag, this.digest);
    }
}

