/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeRunStats;
import org.openrewrite.RecipeSchedulerUtils;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.scheduling.WatchableExecutionContext;

public interface RecipeScheduler {
    default public <T> List<T> mapAsync(List<T> input, UnaryOperator<T> mapFn) {
        CompletableFuture[] futures = new CompletableFuture[input.size()];
        int i = 0;
        for (Object before : input) {
            Callable<Object> updateTreeFn = () -> mapFn.apply(before);
            futures[i++] = this.schedule(updateTreeFn);
        }
        CompletableFuture.allOf(futures).join();
        return ListUtils.map(input, (j, in) -> futures[j].join());
    }

    default public RecipeRun scheduleRun(Recipe recipe, List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles, int minCycles) {
        List<? extends SourceFile> acc;
        RecipeRun recipeRun = new RecipeRun(new RecipeRunStats(recipe), Collections.emptyList());
        HashSet sourceFileIds = new HashSet();
        before = ListUtils.map(before, sourceFile -> {
            if (!sourceFileIds.add(sourceFile.getId())) {
                return (SourceFile)sourceFile.withId(Tree.randomId());
            }
            return sourceFile;
        });
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", recipe.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile = new HashMap<UUID, Stack<Recipe>>();
        List<? extends SourceFile> after = acc = before;
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        for (int i = 0; i < maxCycles && ctx.getMessage("__AHHH_PANIC!!!__") == null; ++i) {
            Stack<Recipe> recipeStack = new Stack<Recipe>();
            recipeStack.push(recipe);
            after = this.scheduleVisit(recipeRun.getStats(), recipeStack, acc, ctxWithWatch, recipeThatAddedOrDeletedSourceFile);
            if (i + 1 >= minCycles && (after == acc && !ctxWithWatch.hasNewMessages() || !recipe.causesAnotherCycle())) break;
            acc = after;
            ctxWithWatch.resetHasNewMessages();
        }
        if (after == before) {
            return recipeRun;
        }
        HashMap<UUID, SourceFile> sourceFileIdentities = new HashMap<UUID, SourceFile>();
        for (SourceFile sourceFile2 : before) {
            sourceFileIdentities.put(sourceFile2.getId(), sourceFile2);
        }
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile3 : after) {
            SourceFile sourceFile4 = (SourceFile)sourceFileIdentities.get(sourceFile3.getId());
            if (sourceFile4 == sourceFile3) continue;
            if (sourceFile4 == null) {
                results.add(new Result(null, sourceFile3, Collections.singletonList((Stack)recipeThatAddedOrDeletedSourceFile.get(sourceFile3.getId()))));
                continue;
            }
            if (sourceFile4.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile4, sourceFile3, sourceFile3.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change")).getRecipes()));
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (SourceFile sourceFile5 : after) {
            hashSet.add(sourceFile5.getId());
        }
        for (SourceFile sourceFile6 : before) {
            if (hashSet.contains(sourceFile6.getId()) || sourceFile6.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile6, null, Collections.singleton((Stack)recipeThatAddedOrDeletedSourceFile.get(sourceFile6.getId()))));
        }
        return recipeRun.withResults(results);
    }

    default public <S extends SourceFile> List<S> scheduleVisit(RecipeRunStats runStats, Stack<Recipe> recipeStack, List<S> before, ExecutionContext ctx, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile) {
        List<SourceFile> afterWidened;
        List<SourceFile> after;
        runStats.calls.incrementAndGet();
        long startTime = System.nanoTime();
        Recipe recipe = recipeStack.peek();
        ctx.putCurrentRecipe(recipe);
        if (ctx instanceof WatchableExecutionContext) {
            ((WatchableExecutionContext)ctx).resetHasNewMessages();
        }
        try {
            if (!recipe.getApplicableTests().isEmpty()) {
                boolean applicable = false;
                block4: for (SourceFile s2 : before) {
                    for (Recipe recipe2 : recipeStack) {
                        for (TreeVisitor<?, ExecutionContext> applicableTest : recipe2.getApplicableTests()) {
                            if (applicableTest.visit(s2, ctx) == s2) continue;
                            applicable = true;
                            break block4;
                        }
                    }
                }
                if (!applicable) {
                    return before;
                }
            }
        }
        catch (Throwable t) {
            return RecipeSchedulerUtils.handleUncaughtException(recipeStack, recipeThatAddedOrDeletedSourceFile, before, ctx, recipe, t);
        }
        AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean(false);
        if (!recipe.validate(ctx).isValid()) {
            after = before;
        } else {
            long getVisitorStartTime = System.nanoTime();
            after = this.mapAsync(before, s -> {
                SourceFile afterFile;
                Timer.Sample sample;
                Timer.Builder timer;
                block13: {
                    timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", recipe.getDisplayName());
                    sample = Timer.start();
                    afterFile = s;
                    try {
                        for (Recipe r : recipeStack) {
                            for (TreeVisitor<?, ExecutionContext> singleSourceApplicableTest : r.getSingleSourceApplicableTests()) {
                                if (singleSourceApplicableTest.visit((Tree)s, ctx) != s) continue;
                                sample.stop(MetricsHelper.successTags(timer, "skipped").register((MeterRegistry)Metrics.globalRegistry));
                                return s;
                            }
                        }
                        Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
                        if (duration.compareTo(ctx.getRunTimeout(before.size())) > 0) {
                            if (thrownErrorOnTimeout.compareAndSet(false, true)) {
                                RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                                ctx.getOnError().accept(t);
                                ctx.getOnTimeout().accept(t, ctx);
                            }
                            sample.stop(MetricsHelper.successTags(timer, "timeout").register((MeterRegistry)Metrics.globalRegistry));
                            return s;
                        }
                        if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                            sample.stop(MetricsHelper.successTags(timer, "panic").register((MeterRegistry)Metrics.globalRegistry));
                            return s;
                        }
                        TreeVisitor<?, ExecutionContext> visitor = recipe.getVisitor();
                        afterFile = (SourceFile)visitor.visitSourceFile((SourceFile)s, ctx);
                        if (visitor.isAcceptable((SourceFile)s, ctx)) {
                            afterFile = (SourceFile)visitor.visit(afterFile, ctx);
                        }
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(t);
                        if (t instanceof RecipeRunException) {
                            RecipeRunException vt = (RecipeRunException)t;
                            afterFile = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(afterFile), 0);
                        }
                        if (afterFile == null) break block13;
                        afterFile = Markup.error(afterFile, t);
                    }
                }
                if (afterFile != null && afterFile != s) {
                    afterFile = RecipeSchedulerUtils.addRecipesThatMadeChanges(recipeStack, afterFile);
                    sample.stop(MetricsHelper.successTags(timer, "changed").register((MeterRegistry)Metrics.globalRegistry));
                } else if (afterFile == null) {
                    recipeThatAddedOrDeletedSourceFile.put(Objects.requireNonNull(s).getId(), recipeStack);
                    sample.stop(MetricsHelper.successTags(timer, "deleted").register((MeterRegistry)Metrics.globalRegistry));
                } else {
                    sample.stop(MetricsHelper.successTags(timer, "unchanged").register((MeterRegistry)Metrics.globalRegistry));
                }
                return afterFile;
            });
            runStats.ownGetVisitor.addAndGet(System.nanoTime() - getVisitorStartTime);
        }
        try {
            long ownVisitStartTime = System.nanoTime();
            afterWidened = recipe.visit(after, ctx);
            runStats.ownVisit.addAndGet(System.nanoTime() - ownVisitStartTime);
        }
        catch (Throwable t) {
            return RecipeSchedulerUtils.handleUncaughtException(recipeStack, recipeThatAddedOrDeletedSourceFile, before, ctx, recipe, t);
        }
        if (afterWidened != after) {
            HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
            for (SourceFile file : after) {
                originalMap.put(file.getId(), file);
            }
            afterWidened = ListUtils.map(afterWidened, s -> {
                SourceFile original = (SourceFile)originalMap.get(s.getId());
                if (original == null) {
                    recipeThatAddedOrDeletedSourceFile.put(s.getId(), recipeStack);
                } else if (s != original) {
                    ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
                    recipeStackList.add(recipeStack);
                    return (SourceFile)s.withMarkers(s.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
                        r1.getRecipes().addAll(r2.getRecipes());
                        return r1;
                    }));
                }
                return s;
            });
            for (SourceFile maybeDeleted : after) {
                if (afterWidened.contains(maybeDeleted)) continue;
                recipeThatAddedOrDeletedSourceFile.put(maybeDeleted.getId(), recipeStack);
            }
        }
        for (Recipe recipe3 : recipe.getRecipeList()) {
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return afterWidened;
            }
            Stack<Recipe> nextStack = new Stack<Recipe>();
            nextStack.addAll(recipeStack);
            nextStack.push(recipe3);
            RecipeRunStats nextStats = null;
            for (RecipeRunStats called : runStats.getCalled()) {
                if (called.recipe != recipe3) continue;
                nextStats = called;
                break;
            }
            if (nextStats == null) {
                nextStats = new RecipeRunStats(recipe3);
                runStats.getCalled().add(nextStats);
            }
            afterWidened = this.scheduleVisit(Objects.requireNonNull(nextStats), nextStack, afterWidened, ctx, recipeThatAddedOrDeletedSourceFile);
        }
        long totalTime = System.nanoTime() - startTime;
        runStats.max.compareAndSet(Math.min(runStats.max.get(), totalTime), totalTime);
        runStats.cumulative.addAndGet(totalTime);
        return afterWidened;
    }

    public <T> CompletableFuture<T> schedule(Callable<T> var1);
}

