/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.intellij.lang.annotations.Language;
import org.openrewrite.FileAttributes;
import org.openrewrite.PathUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.Remote;

public final class RemoteArchive
implements Remote {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final URI uri;
    @Nullable
    private final Charset charset;
    private final boolean charsetBomMarked;
    @Nullable
    private final FileAttributes fileAttributes;
    @Language(value="markdown")
    private final String description;
    private final Path path;

    @Override
    public InputStream getInputStream(HttpSender httpSender) {
        HttpSender.Response response = httpSender.send(httpSender.get(this.uri.toString()).build());
        InputStream body = response.getBody();
        return this.readIntoArchive(body, this.path.toString());
    }

    private InputStream readIntoArchive(InputStream body, String path) {
        String pathBeforeBang;
        String pathAfterBang = null;
        int bangIndex = path.indexOf(33);
        if (bangIndex == -1) {
            pathBeforeBang = path;
        } else {
            pathBeforeBang = path.substring(0, bangIndex);
            pathAfterBang = path.substring(bangIndex + 1);
        }
        final ZipInputStream zis = new ZipInputStream(body);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!PathUtils.equalIgnoringSeparators(entry.getName(), pathBeforeBang)) continue;
                if (pathAfterBang == null) {
                    return new InputStream(){

                        @Override
                        public int read() throws IOException {
                            return zis.read();
                        }

                        @Override
                        public void close() throws IOException {
                            zis.closeEntry();
                            zis.close();
                        }
                    };
                }
                return this.readIntoArchive(zis, pathAfterBang);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load path " + path + " in zip file " + this.uri, e);
        }
        throw new IllegalArgumentException("Unable to find path " + path + " in zip file " + this.uri);
    }

    public RemoteArchive(UUID id, Path sourcePath, Markers markers, URI uri, @Nullable Charset charset, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Language(value="markdown") String description, Path path) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.uri = uri;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.description = description;
        this.path = path;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Nullable
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    public Path getPath() {
        return this.path;
    }

    @NonNull
    public String toString() {
        return "RemoteArchive(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", uri=" + this.getUri() + ", charset=" + this.getCharset() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", description=" + this.getDescription() + ", path=" + this.getPath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteArchive)) {
            return false;
        }
        RemoteArchive other = (RemoteArchive)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public RemoteArchive withId(UUID id) {
        return this.id == id ? this : new RemoteArchive(id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new RemoteArchive(this.id, sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withMarkers(Markers markers) {
        return this.markers == markers ? this : new RemoteArchive(this.id, this.sourcePath, markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withUri(URI uri) {
        return this.uri == uri ? this : new RemoteArchive(this.id, this.sourcePath, this.markers, uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withCharset(@Nullable Charset charset) {
        return this.charset == charset ? this : new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, charset, this.charsetBomMarked, this.fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, this.charset, charsetBomMarked, this.fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, fileAttributes, this.description, this.path);
    }

    @NonNull
    public RemoteArchive withDescription(@Language(value="markdown") String description) {
        return this.description == description ? this : new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, description, this.path);
    }

    @NonNull
    public RemoteArchive withPath(Path path) {
        return this.path == path ? this : new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, path);
    }
}

