/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class CategoryDescriptor {
    public static final int LOWEST_PRECEDENCE = 0;
    public static final int HIGHEST_PRECEDENCE = Integer.MAX_VALUE;
    @Language(value="markdown")
    private final String displayName;
    private final String packageName;
    @Language(value="markdown")
    private final String description;
    private final Set<String> tags;
    private final boolean root;
    private final int priority;
    private final boolean synthetic;

    public CategoryDescriptor(@Language(value="markdown") String displayName, String packageName, @Language(value="markdown") String description, Set<String> tags, boolean root, int priority, boolean synthetic) {
        this.displayName = displayName;
        this.packageName = packageName;
        this.description = description;
        this.tags = tags;
        this.root = root;
        this.priority = priority;
        this.synthetic = synthetic;
    }

    @Language(value="markdown")
    public String getDisplayName() {
        return this.displayName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean isRoot() {
        return this.root;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryDescriptor)) {
            return false;
        }
        CategoryDescriptor other = (CategoryDescriptor)o;
        if (this.isRoot() != other.isRoot()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isSynthetic() != other.isSynthetic()) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRoot() ? 79 : 97);
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isSynthetic() ? 79 : 97);
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "CategoryDescriptor(displayName=" + this.getDisplayName() + ", packageName=" + this.getPackageName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", root=" + this.isRoot() + ", priority=" + this.getPriority() + ", synthetic=" + this.isSynthetic() + ")";
    }

    @NonNull
    public CategoryDescriptor withDisplayName(@Language(value="markdown") String displayName) {
        return this.displayName == displayName ? this : new CategoryDescriptor(displayName, this.packageName, this.description, this.tags, this.root, this.priority, this.synthetic);
    }

    @NonNull
    public CategoryDescriptor withPackageName(String packageName) {
        return this.packageName == packageName ? this : new CategoryDescriptor(this.displayName, packageName, this.description, this.tags, this.root, this.priority, this.synthetic);
    }

    @NonNull
    public CategoryDescriptor withDescription(@Language(value="markdown") String description) {
        return this.description == description ? this : new CategoryDescriptor(this.displayName, this.packageName, description, this.tags, this.root, this.priority, this.synthetic);
    }

    @NonNull
    public CategoryDescriptor withTags(Set<String> tags) {
        return this.tags == tags ? this : new CategoryDescriptor(this.displayName, this.packageName, this.description, tags, this.root, this.priority, this.synthetic);
    }

    @NonNull
    public CategoryDescriptor withRoot(boolean root) {
        return this.root == root ? this : new CategoryDescriptor(this.displayName, this.packageName, this.description, this.tags, root, this.priority, this.synthetic);
    }

    @NonNull
    public CategoryDescriptor withPriority(int priority) {
        return this.priority == priority ? this : new CategoryDescriptor(this.displayName, this.packageName, this.description, this.tags, this.root, priority, this.synthetic);
    }

    @NonNull
    public CategoryDescriptor withSynthetic(boolean synthetic) {
        return this.synthetic == synthetic ? this : new CategoryDescriptor(this.displayName, this.packageName, this.description, this.tags, this.root, this.priority, synthetic);
    }
}

