/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.net.URI;
import java.util.stream.Collectors;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;

public class ValidationException
extends RuntimeException {
    private URI source;

    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public ValidationException(Validated validation) {
        this(validation, null);
    }

    public ValidationException(Validated validation, @Nullable URI source) {
        super(validation.failures().stream().map(invalid -> invalid.getProperty() + " was '" + (invalid.getValue() == null ? "null" : invalid.getValue()) + "' but it " + invalid.getMessage()).collect(Collectors.joining("\n", validation.failures().size() > 1 ? "Multiple validation failures:\n" : "", "")));
        this.source = source;
    }

    @Override
    public String getMessage() {
        if (this.source != null) {
            return "Problem parsing rewrite configuration from: " + this.source + " \n" + super.getMessage();
        }
        return super.getMessage();
    }
}

