/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.UncaughtVisitorException;
import org.openrewrite.internal.FindUncaughtVisitorException;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MarkerIdPrinter;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.scheduling.WatchableExecutionContext;

public interface RecipeScheduler {
    default public <T> List<T> mapAsync(List<T> input, UnaryOperator<T> mapFn) {
        CompletableFuture[] futures = new CompletableFuture[input.size()];
        int i = 0;
        for (Object before : input) {
            Callable<Object> updateTreeFn = () -> mapFn.apply(before);
            futures[i++] = this.schedule(updateTreeFn);
        }
        CompletableFuture.allOf(futures).join();
        return ListUtils.map(input, (j, in) -> futures[j].join());
    }

    default public List<Result> scheduleRun(Recipe recipe, List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles, int minCycles) {
        List<? extends SourceFile> acc;
        HashSet sourceFileIds = new HashSet();
        before = ListUtils.map(before, sourceFile -> {
            if (!sourceFileIds.add(sourceFile.getId())) {
                return (SourceFile)sourceFile.withId(Tree.randomId());
            }
            return sourceFile;
        });
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", recipe.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Stack<Recipe>> recipeThatDeletedSourceFile = new HashMap<UUID, Stack<Recipe>>();
        List<? extends SourceFile> after = acc = before;
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        for (int i = 0; i < maxCycles; ++i) {
            Stack<Recipe> recipeStack = new Stack<Recipe>();
            recipeStack.push(recipe);
            after = this.scheduleVisit(recipeStack, acc, ctxWithWatch, recipeThatDeletedSourceFile);
            if (i + 1 >= minCycles && (after == acc && !ctxWithWatch.hasNewMessages() || !recipe.causesAnotherCycle())) break;
            acc = after;
            ctxWithWatch.resetHasNewMessages();
        }
        if (after == before) {
            return Collections.emptyList();
        }
        HashMap<UUID, SourceFile> sourceFileIdentities = new HashMap<UUID, SourceFile>();
        for (SourceFile sourceFile2 : before) {
            sourceFileIdentities.put(sourceFile2.getId(), sourceFile2);
        }
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile3 : after) {
            boolean isChanged;
            SourceFile sourceFile4 = (SourceFile)sourceFileIdentities.get(sourceFile3.getId());
            if (sourceFile4 == sourceFile3) continue;
            if (sourceFile4 == null) {
                results.add(new Result(null, sourceFile3, Collections.singleton((Stack)recipeThatDeletedSourceFile.get(sourceFile3.getId()))));
                continue;
            }
            if (sourceFile4.getMarkers().findFirst(Generated.class).isPresent()) continue;
            boolean bl = isChanged = !sourceFile4.getSourcePath().equals(sourceFile3.getSourcePath());
            if (!isChanged) {
                MarkerIdPrinter markerIdPrinter = new MarkerIdPrinter();
                PrintOutputCapture<ExecutionContext> originalOutput = new PrintOutputCapture<ExecutionContext>(ctx);
                PrintOutputCapture<ExecutionContext> sOutput = new PrintOutputCapture<ExecutionContext>(ctx);
                markerIdPrinter.visit((Tree)sourceFile4, originalOutput);
                markerIdPrinter.visit((Tree)sourceFile3, sOutput);
                boolean bl2 = isChanged = !originalOutput.toString().equals(sOutput.toString());
            }
            if (!isChanged) continue;
            results.add(new Result(sourceFile4, sourceFile3, sourceFile3.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change. Did a recipe apply a marker?")).getRecipes()));
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (SourceFile sourceFile5 : after) {
            hashSet.add(sourceFile5.getId());
        }
        for (SourceFile sourceFile6 : before) {
            if (hashSet.contains(sourceFile6.getId()) || sourceFile6.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile6, null, Collections.singleton((Stack)recipeThatDeletedSourceFile.get(sourceFile6.getId()))));
        }
        return results;
    }

    default public <S extends SourceFile> List<S> scheduleVisit(Stack<Recipe> recipeStack, List<S> before, ExecutionContext ctx, Map<UUID, Stack<Recipe>> recipeThatDeletedSourceFile) {
        List<SourceFile> afterWidened;
        long startTime = System.nanoTime();
        Recipe recipe = recipeStack.peek();
        ctx.putCurrentRecipe(recipe);
        if (ctx instanceof WatchableExecutionContext) {
            ((WatchableExecutionContext)ctx).resetHasNewMessages();
        }
        try {
            if (recipe.getApplicableTest() != null) {
                boolean applicable = false;
                block4: for (SourceFile s2 : before) {
                    if (recipe.getApplicableTest().visit(s2, ctx) != s2) {
                        applicable = true;
                        break;
                    }
                    for (TreeVisitor<?, ExecutionContext> treeVisitor : recipe.getApplicableTests()) {
                        if (treeVisitor.visit(s2, ctx) == s2) continue;
                        applicable = true;
                        continue block4;
                    }
                }
                if (!applicable) {
                    return before;
                }
            }
        }
        catch (Throwable t) {
            ctx.getOnError().accept(t);
            return before;
        }
        AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean(false);
        List<SourceFile> after = !recipe.validate(ctx).isValid() ? before : this.mapAsync(before, s -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", recipe.getDisplayName());
            Timer.Sample sample = Timer.start();
            SourceFile afterFile = s;
            try {
                if (recipe.getSingleSourceApplicableTest() != null && recipe.getSingleSourceApplicableTest().visit((Tree)s, ctx) == s) {
                    sample.stop(MetricsHelper.successTags(timer, "skipped").register((MeterRegistry)Metrics.globalRegistry));
                    return s;
                }
                for (TreeVisitor<?, ExecutionContext> singleSourceApplicableTest : recipe.getSingleSourceApplicableTests()) {
                    if (singleSourceApplicableTest.visit((Tree)s, ctx) != s) continue;
                    sample.stop(MetricsHelper.successTags(timer, "skipped").register((MeterRegistry)Metrics.globalRegistry));
                    return s;
                }
                Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
                if (duration.compareTo(ctx.getRunTimeout(before.size())) > 0) {
                    if (thrownErrorOnTimeout.compareAndSet(false, true)) {
                        RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                        ctx.getOnError().accept(t);
                        ctx.getOnTimeout().accept(t, ctx);
                    }
                    sample.stop(MetricsHelper.successTags(timer, "timeout").register((MeterRegistry)Metrics.globalRegistry));
                    return s;
                }
                if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                    sample.stop(MetricsHelper.successTags(timer, "panic").register((MeterRegistry)Metrics.globalRegistry));
                    return s;
                }
                TreeVisitor<?, ExecutionContext> visitor = recipe.getVisitor();
                afterFile = (SourceFile)visitor.visitSourceFile((SourceFile)s, ctx);
                if (visitor.isAcceptable((SourceFile)s, ctx)) {
                    afterFile = (SourceFile)visitor.visit(afterFile, ctx);
                }
            }
            catch (Throwable t) {
                if (t instanceof UncaughtVisitorException) {
                    UncaughtVisitorException vt = (UncaughtVisitorException)t;
                    afterFile = (SourceFile)new FindUncaughtVisitorException(vt).visitNonNull(Objects.requireNonNull(afterFile), 0);
                }
                sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
            }
            if (afterFile != null && afterFile != s) {
                ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
                recipeStackList.add(recipeStack);
                afterFile = afterFile.withMarkers(afterFile.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
                    r1.getRecipes().addAll(r2.getRecipes());
                    return r1;
                }));
                sample.stop(MetricsHelper.successTags(timer, "changed").register((MeterRegistry)Metrics.globalRegistry));
            } else if (afterFile == null) {
                recipeThatDeletedSourceFile.put(Objects.requireNonNull(s).getId(), recipeStack);
                sample.stop(MetricsHelper.successTags(timer, "deleted").register((MeterRegistry)Metrics.globalRegistry));
            } else {
                sample.stop(MetricsHelper.successTags(timer, "unchanged").register((MeterRegistry)Metrics.globalRegistry));
            }
            return afterFile;
        });
        try {
            afterWidened = recipe.visit(after, ctx);
        }
        catch (Throwable t) {
            ctx.getOnError().accept(t);
            return before;
        }
        if (afterWidened != after) {
            HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
            for (SourceFile file : after) {
                originalMap.put(file.getId(), file);
            }
            afterWidened = ListUtils.map(afterWidened, s -> {
                SourceFile original = (SourceFile)originalMap.get(s.getId());
                if (original == null) {
                    recipeThatDeletedSourceFile.put(s.getId(), recipeStack);
                } else if (s != original) {
                    ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
                    recipeStackList.add(recipeStack);
                    return s.withMarkers(s.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
                        r1.getRecipes().addAll(r2.getRecipes());
                        return r1;
                    }));
                }
                return s;
            });
            for (SourceFile maybeDeleted : after) {
                if (afterWidened.contains(maybeDeleted)) continue;
                recipeThatDeletedSourceFile.put(maybeDeleted.getId(), recipeStack);
            }
        }
        for (Recipe recipe2 : recipe.getRecipeList()) {
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return afterWidened;
            }
            Stack<Recipe> nextStack = new Stack<Recipe>();
            nextStack.addAll(recipeStack);
            nextStack.push(recipe2);
            afterWidened = this.scheduleVisit(nextStack, afterWidened, ctx, recipeThatDeletedSourceFile);
        }
        return afterWidened;
    }

    public <T> CompletableFuture<T> schedule(Callable<T> var1);
}

