/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class FindSourceFiles
extends Recipe {
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root).", example=".github/workflows/*.yml")
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Find files";
    }

    @Override
    public String getDescription() {
        return "Find files by source path.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                SourceFile sourceFile;
                Path sourcePath;
                PathMatcher pathMatcher;
                if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher("glob:" + FindSourceFiles.this.filePattern)).matches(sourcePath)) {
                    return sourceFile.withMarkers(sourceFile.getMarkers().searchResult());
                }
                return tree;
            }
        };
    }

    public FindSourceFiles(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "FindSourceFiles(filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindSourceFiles)) {
            return false;
        }
        FindSourceFiles other = (FindSourceFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindSourceFiles;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

