/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.OperatingSystem;

public final class DroneBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildId;
    private final String host;
    private final String job;

    public static DroneBuildEnvironment build(UnaryOperator<String> environment) {
        return new DroneBuildEnvironment(Tree.randomId(), (String)environment.apply("DRONE_BUILD_NUMBER"), OperatingSystem.hostname(), (String)environment.apply("DRONE_REPO"));
    }

    public String getBuildUrl() {
        return "http://" + this.host + "/build/" + this.buildId;
    }

    public DroneBuildEnvironment(UUID id, String buildId, String host, String job) {
        this.id = id;
        this.buildId = buildId;
        this.host = host;
        this.job = job;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    @NonNull
    public String toString() {
        return "DroneBuildEnvironment(id=" + this.getId() + ", buildId=" + this.getBuildId() + ", host=" + this.getHost() + ", job=" + this.getJob() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DroneBuildEnvironment)) {
            return false;
        }
        DroneBuildEnvironment other = (DroneBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        return !(this$job == null ? other$job != null : !this$job.equals(other$job));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        return result;
    }

    @NonNull
    public DroneBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new DroneBuildEnvironment(id, this.buildId, this.host, this.job);
    }
}

