/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.openrewrite.internal.lang.Nullable;

public class EncodingDetectingInputStream
extends InputStream {
    private static final Charset WINDOWS_1252 = Charset.forName("Windows-1252");
    private final InputStream inputStream;
    @Nullable
    private Charset charset;
    private boolean charsetBomMarked;
    private int prev;
    private int prev2;
    private int prev3;
    boolean maybeTwoByteSequence = false;
    boolean maybeThreeByteSequence = false;
    boolean maybeFourByteSequence = false;

    public EncodingDetectingInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Charset getCharset() {
        return this.charset == null ? StandardCharsets.UTF_8 : this.charset;
    }

    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    public int read() throws IOException {
        int aByte = this.inputStream.read();
        if (this.charset == null) {
            if (this.prev3 == 195 && this.prev2 == 175 && this.prev == 194) {
                this.charsetBomMarked = true;
                this.charset = StandardCharsets.UTF_8;
            } else {
                if (aByte == -1 || (this.prev2 != 0 || this.prev != 195) && (this.prev3 != 0 || this.prev2 != 195)) {
                    if (this.maybeTwoByteSequence) {
                        if (aByte == -1 && !this.utf8SequenceEnd(this.prev) || aByte != -1 && !this.utf8SequenceEnd(aByte)) {
                            this.charset = WINDOWS_1252;
                        } else {
                            this.maybeTwoByteSequence = false;
                            this.prev2 = -1;
                            this.prev = -1;
                        }
                    } else if (this.maybeThreeByteSequence) {
                        if (aByte == -1 || this.utf8SequenceEnd(this.prev) && !this.utf8SequenceEnd(aByte) || !this.utf8SequenceEnd(aByte)) {
                            this.charset = WINDOWS_1252;
                        }
                        if (this.utf8SequenceEnd(this.prev) && this.utf8SequenceEnd(aByte)) {
                            this.maybeThreeByteSequence = false;
                            this.prev2 = -1;
                            this.prev = -1;
                        }
                    } else if (this.maybeFourByteSequence) {
                        if (aByte == -1 || this.utf8SequenceEnd(this.prev2) && this.utf8SequenceEnd(this.prev) && !this.utf8SequenceEnd(aByte) || this.utf8SequenceEnd(this.prev) && !this.utf8SequenceEnd(aByte) || !this.utf8SequenceEnd(aByte)) {
                            this.charset = WINDOWS_1252;
                        }
                        if (this.utf8SequenceEnd(this.prev2) && this.utf8SequenceEnd(this.prev) && this.utf8SequenceEnd(aByte)) {
                            this.maybeFourByteSequence = false;
                            this.prev2 = -1;
                            this.prev = -1;
                        }
                    } else if (this.utf8TwoByteSequence(aByte)) {
                        this.maybeTwoByteSequence = true;
                    } else if (this.utf8ThreeByteSequence(aByte)) {
                        this.maybeThreeByteSequence = true;
                    } else if (this.utf8FourByteSequence(aByte)) {
                        this.maybeFourByteSequence = true;
                    } else if (!this.utf8TwoByteSequence(this.prev) && this.utf8SequenceEnd(aByte)) {
                        this.charset = WINDOWS_1252;
                    }
                }
                if (aByte == -1 && this.charset == null) {
                    this.charset = StandardCharsets.UTF_8;
                }
            }
            this.prev3 = this.prev2;
            this.prev2 = this.prev;
            this.prev = aByte;
        }
        return aByte;
    }

    public String readFully() {
        String string;
        block9: {
            EncodingDetectingInputStream is = this;
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((n = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, n);
                }
                byte[] bytes = bos.toByteArray();
                string = new String(bytes, 0, bytes.length, this.getCharset());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            is.close();
        }
        return string;
    }

    private boolean utf8TwoByteSequence(int b) {
        return 192 <= b && b <= 223;
    }

    private boolean utf8ThreeByteSequence(int b) {
        return 224 <= b && b <= 239;
    }

    private boolean utf8FourByteSequence(int b) {
        return 240 <= b && b <= 247;
    }

    private boolean utf8SequenceEnd(int b) {
        return 128 <= b && b <= 191;
    }
}

