/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.TildeRange;
import org.openrewrite.semver.VersionComparator;

public final class LatestPatch
implements VersionComparator {
    @Nullable
    private final String metadataPattern;

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return ((VersionComparator)TildeRange.build("~" + Semver.majorVersion(currentVersion) + "." + Semver.minorVersion(currentVersion), this.metadataPattern).getValue()).isValid(currentVersion, version);
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        return ((VersionComparator)TildeRange.build("~" + Semver.majorVersion(currentVersion) + "." + Semver.minorVersion(currentVersion), this.metadataPattern).getValue()).compare(currentVersion, v1, v2);
    }

    public static Validated build(String toVersion, @Nullable String metadataPattern) {
        return "latest.patch".equalsIgnoreCase(toVersion) ? Validated.valid("latestPatch", new LatestPatch(metadataPattern)) : Validated.invalid("latestPatch", toVersion, "not latest release");
    }

    public LatestPatch(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    @Nullable
    public String getMetadataPattern() {
        return this.metadataPattern;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatestPatch)) {
            return false;
        }
        LatestPatch other = (LatestPatch)o;
        String this$metadataPattern = this.getMetadataPattern();
        String other$metadataPattern = other.getMetadataPattern();
        return !(this$metadataPattern == null ? other$metadataPattern != null : !this$metadataPattern.equals(other$metadataPattern));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $metadataPattern = this.getMetadataPattern();
        result = result * 59 + ($metadataPattern == null ? 43 : $metadataPattern.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "LatestPatch(metadataPattern=" + this.getMetadataPattern() + ")";
    }
}

