/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.ci.BuildEnvironment;

public final class GithubActionsBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildNumber;
    private final String buildId;
    private final String host;
    private final String job;

    public static GithubActionsBuildEnvironment build(UnaryOperator<String> environment) {
        return new GithubActionsBuildEnvironment(Tree.randomId(), (String)environment.apply("GITHUB_RUN_NUMBER"), (String)environment.apply("GITHUB_RUN_ID"), (String)environment.apply("GITHUB_SERVER_URL"), (String)environment.apply("GITHUB_ACTION"));
    }

    public String getBuildUrl() {
        return this.host + "/" + this.buildId;
    }

    public GithubActionsBuildEnvironment(UUID id, String buildNumber, String buildId, String host, String job) {
        this.id = id;
        this.buildNumber = buildNumber;
        this.buildId = buildId;
        this.host = host;
        this.job = job;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    @NonNull
    public String toString() {
        return "GithubActionsBuildEnvironment(id=" + this.getId() + ", buildNumber=" + this.getBuildNumber() + ", buildId=" + this.getBuildId() + ", host=" + this.getHost() + ", job=" + this.getJob() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GithubActionsBuildEnvironment)) {
            return false;
        }
        GithubActionsBuildEnvironment other = (GithubActionsBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildNumber = this.getBuildNumber();
        String other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        return !(this$job == null ? other$job != null : !this$job.equals(other$job));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        return result;
    }

    @NonNull
    public GithubActionsBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new GithubActionsBuildEnvironment(id, this.buildNumber, this.buildId, this.host, this.job);
    }
}

