/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public class HasSourcePath<P>
extends TreeVisitor<Tree, P> {
    private final String syntax;
    private final String filePattern;

    public HasSourcePath(@Nullable String filePattern) {
        this("glob", filePattern);
    }

    public HasSourcePath(String syntax, @Nullable String filePattern) {
        this.syntax = syntax;
        this.filePattern = filePattern;
    }

    @Override
    @Nullable
    public Tree visit(@Nullable Tree tree, P p) {
        SourceFile sourceFile;
        Path sourcePath;
        PathMatcher pathMatcher;
        if (this.filePattern == null) {
            return new SearchResult(Tree.randomId(), "has file");
        }
        if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath().normalize()).getFileSystem().getPathMatcher(this.syntax + ":" + this.filePattern)).matches(sourcePath)) {
            return sourceFile.withMarkers(sourceFile.getMarkers().searchResult("has file"));
        }
        return tree;
    }
}

