/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.internal.lang.NonNullApi;

@NonNullApi
public class LoggingMeterRegistry
extends MeterRegistry {
    private final long startInterval;
    private final TimeUnit baseTimeUnit;
    private final Consumer<String> loggingSink;
    private final Function<Meter, String> meterIdPrinter;

    public LoggingMeterRegistry(TimeUnit baseTimeUnit, Consumer<String> loggingSink, @Nullable Function<Meter, String> meterIdPrinter) {
        super(Clock.SYSTEM);
        this.baseTimeUnit = baseTimeUnit;
        this.startInterval = this.clock.monotonicTime();
        this.loggingSink = loggingSink;
        this.meterIdPrinter = meterIdPrinter != null ? meterIdPrinter : this.defaultMeterIdPrinter();
        this.config().namingConvention(NamingConvention.dot);
    }

    private Function<Meter, String> defaultMeterIdPrinter() {
        return meter -> this.getConventionName(meter.getId()) + this.getConventionTags(meter.getId()).stream().map(t -> t.getKey() + "=" + t.getValue()).collect(Collectors.joining(",", "{", "}"));
    }

    public void print() {
        this.getMeters().stream().sorted((m1, m2) -> {
            int typeComp = m1.getId().getType().compareTo((Enum)m2.getId().getType());
            if (typeComp == 0) {
                return m1.getId().getName().compareTo(m2.getId().getName());
            }
            return typeComp;
        }).forEach(m -> {
            Printer print = new Printer((Meter)m);
            m.use(gauge -> this.loggingSink.accept(print.id() + "\n    value=" + print.value(gauge.value())), counter -> {
                double count = counter.count();
                if (count == 0.0) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    sum=" + print.value(count) + "\n    rate=" + print.rate(count));
            }, timer -> {
                HistogramSnapshot snapshot = timer.takeSnapshot();
                long count = snapshot.count();
                if (count == 0L) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    sum=" + count + "\n    rate=" + print.unitlessRate(count) + "\n    mean=" + print.time(snapshot.mean(this.getBaseTimeUnit())) + "\n    max=" + print.time(snapshot.max(this.getBaseTimeUnit())));
            }, summary -> {
                HistogramSnapshot snapshot = summary.takeSnapshot();
                long count = snapshot.count();
                if (count == 0L) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    sum=" + count + "\n    rate=" + print.unitlessRate(count) + "\n    mean=" + print.value(snapshot.mean()) + "\n    max=" + print.value(snapshot.max()));
            }, longTaskTimer -> {
                int activeTasks = longTaskTimer.activeTasks();
                if (activeTasks == 0) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    active=" + print.value(activeTasks) + "\n    duration=" + print.time(longTaskTimer.duration(this.getBaseTimeUnit())));
            }, timeGauge -> {
                double value = timeGauge.value(this.getBaseTimeUnit());
                if (value == 0.0) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    value=" + print.time(value));
            }, counter -> {
                double count = counter.count();
                if (count == 0.0) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    sum=" + print.value(count) + "\n    rate=" + print.rate(count));
            }, timer -> {
                double count = timer.count();
                if (count == 0.0) {
                    return;
                }
                this.loggingSink.accept(print.id() + "\n    sum=" + print.value(count) + "\n    rate=" + print.rate(count) + "\n    mean=" + print.time(timer.mean(this.getBaseTimeUnit())));
            }, meter -> this.loggingSink.accept(this.writeMeter((Meter)meter, print)));
        });
    }

    String writeMeter(Meter meter, Printer print) {
        return StreamSupport.stream(meter.measure().spliterator(), false).map(ms -> {
            String msLine = ms.getStatistic().getTagValueRepresentation() + "=";
            switch (ms.getStatistic()) {
                case TOTAL: 
                case MAX: 
                case VALUE: {
                    return msLine + print.value(ms.getValue());
                }
                case TOTAL_TIME: 
                case DURATION: {
                    return msLine + print.time(ms.getValue());
                }
                case COUNT: {
                    return "\n    sum=" + print.value(ms.getValue()) + "\n    rate=" + print.rate(ms.getValue());
                }
            }
            return msLine + DoubleFormat.decimalOrNan((double)ms.getValue());
        }).collect(Collectors.joining(", ", print.id() + " ", ""));
    }

    protected TimeUnit getBaseTimeUnit() {
        return this.baseTimeUnit;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.DEFAULT;
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new DefaultLongTaskTimer(id, this.clock, this.baseTimeUnit, distributionStatisticConfig, false);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new CumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), false);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new CumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, scale, false);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        throw new UnsupportedOperationException("Does not support custom meter types.");
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.baseTimeUnit);
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TimeUnit baseTimeUnit = TimeUnit.MILLISECONDS;
        private Consumer<String> loggingSink = System.out::println;
        @Nullable
        private Function<Meter, String> meterIdPrinter;

        public Builder baseTimeUnit(TimeUnit baseTimeUnit) {
            this.baseTimeUnit = baseTimeUnit;
            return this;
        }

        public Builder loggingSink(Consumer<String> loggingSink) {
            this.loggingSink = loggingSink;
            return this;
        }

        public Builder meterIdPrinter(Function<Meter, String> meterIdPrinter) {
            this.meterIdPrinter = meterIdPrinter;
            return this;
        }

        public LoggingMeterRegistry build() {
            return new LoggingMeterRegistry(this.baseTimeUnit, this.loggingSink, this.meterIdPrinter);
        }
    }

    class Printer {
        private final Duration interval;
        private final Meter meter;

        Printer(Meter meter) {
            this.interval = Duration.ofNanos(LoggingMeterRegistry.this.clock.monotonicTime() - LoggingMeterRegistry.this.startInterval);
            this.meter = meter;
        }

        String id() {
            return (String)LoggingMeterRegistry.this.meterIdPrinter.apply(this.meter);
        }

        String time(double time) {
            return TimeUtils.format((Duration)Duration.ofNanos((long)TimeUtils.convert((double)time, (TimeUnit)LoggingMeterRegistry.this.getBaseTimeUnit(), (TimeUnit)TimeUnit.NANOSECONDS)));
        }

        String rate(double rate) {
            return this.humanReadableBaseUnit(rate / ((double)this.interval.getNano() / 1.0E9)) + "/s";
        }

        String unitlessRate(double rate) {
            return DoubleFormat.decimalOrNan((double)(rate / ((double)this.interval.getNano() / 1.0E9))) + "/s";
        }

        String value(double value) {
            return this.humanReadableBaseUnit(value);
        }

        String humanReadableByteCount(double bytes) {
            int unit = 1024;
            if (bytes < (double)unit || Double.isNaN(bytes)) {
                return DoubleFormat.decimalOrNan((double)bytes) + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = "KMGTPE".charAt(exp - 1) + "i";
            return DoubleFormat.decimalOrNan((double)(bytes / Math.pow(unit, exp))) + " " + pre + "B";
        }

        String humanReadableBaseUnit(double value) {
            String baseUnit = this.meter.getId().getBaseUnit();
            if ("bytes".equals(baseUnit)) {
                return this.humanReadableByteCount(value);
            }
            return DoubleFormat.decimalOrNan((double)value) + (baseUnit != null ? " " + baseUnit : "");
        }
    }
}

