/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.dataflow;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Incubating;
import org.openrewrite.dataflow.BasicBlock;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@Incubating(since="7.22.0")
public class ControlFlowGraph<S> {
    BasicBlock<S> basicBlock;
    List<? extends ControlFlowGraph<S>> children;
    List<? extends ControlFlowGraph<S>> loops;

    public void unsafeSetChildren(List<? extends ControlFlowGraph<S>> children) {
        this.children = children;
    }

    public void unsafeSetLoops(List<? extends ControlFlowGraph<S>> loops) {
        this.loops = loops;
    }

    public Stream<BasicBlock<S>> postorder() {
        Stream.Builder<BasicBlock<S>> postorder = Stream.builder();
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        Stack<ControlFlowGraph<S>> s = new Stack<ControlFlowGraph<S>>();
        s.add(this);
        block0: while (!s.isEmpty()) {
            ControlFlowGraph current = (ControlFlowGraph)s.peek();
            for (int i = current.children.size() - 1; i >= 0; --i) {
                ControlFlowGraph<S> child = current.children.get(i);
                if (!seen.add(child)) continue;
                s.add(child);
                continue block0;
            }
            postorder.add(current.basicBlock);
            s.pop();
        }
        return postorder.build();
    }

    public Stream<BasicBlock<S>> reversePostorder() {
        return this.postorder().collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
            Collections.reverse(l);
            return l;
        })).stream();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControlFlowGraph)) {
            return false;
        }
        ControlFlowGraph other = (ControlFlowGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BasicBlock<S> this$basicBlock = this.getBasicBlock();
        BasicBlock<S> other$basicBlock = other.getBasicBlock();
        if (this$basicBlock == null ? other$basicBlock != null : !((Object)this$basicBlock).equals(other$basicBlock)) {
            return false;
        }
        List<ControlFlowGraph<S>> this$children = this.getChildren();
        List<ControlFlowGraph<S>> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List<ControlFlowGraph<S>> this$loops = this.getLoops();
        List<ControlFlowGraph<S>> other$loops = other.getLoops();
        return !(this$loops == null ? other$loops != null : !((Object)this$loops).equals(other$loops));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ControlFlowGraph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BasicBlock<S> $basicBlock = this.getBasicBlock();
        result = result * 59 + ($basicBlock == null ? 43 : ((Object)$basicBlock).hashCode());
        List<ControlFlowGraph<S>> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List<ControlFlowGraph<S>> $loops = this.getLoops();
        result = result * 59 + ($loops == null ? 43 : ((Object)$loops).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ControlFlowGraph(basicBlock=" + this.getBasicBlock() + ", children=" + this.getChildren() + ", loops=" + this.getLoops() + ")";
    }

    public ControlFlowGraph(BasicBlock<S> basicBlock, List<? extends ControlFlowGraph<S>> children, List<? extends ControlFlowGraph<S>> loops) {
        this.basicBlock = basicBlock;
        this.children = children;
        this.loops = loops;
    }

    protected BasicBlock<S> getBasicBlock() {
        return this.basicBlock;
    }

    protected List<? extends ControlFlowGraph<S>> getChildren() {
        return this.children;
    }

    protected List<? extends ControlFlowGraph<S>> getLoops() {
        return this.loops;
    }

    private void setBasicBlock(BasicBlock<S> basicBlock) {
        this.basicBlock = basicBlock;
    }

    private void setChildren(List<? extends ControlFlowGraph<S>> children) {
        this.children = children;
    }

    private void setLoops(List<? extends ControlFlowGraph<S>> loops) {
        this.loops = loops;
    }
}

