/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.binary;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.BinaryVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public final class Binary
implements SourceFile,
Tree {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final byte[] bytes;

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof BinaryVisitor;
    }

    @Override
    public Charset getCharset() {
        throw new UnsupportedOperationException("Binary files do not have a character encoding.");
    }

    @Override
    public SourceFile withCharset(Charset charset) {
        throw new UnsupportedOperationException("Binary files do not have a character encoding.");
    }

    @Override
    public boolean isCharsetBomMarked() {
        throw new UnsupportedOperationException("Binary files do not have a character encoding.");
    }

    @Override
    public SourceFile withCharsetBomMarked(boolean marked) {
        throw new UnsupportedOperationException("Binary files do not have a character encoding.");
    }

    @Override
    public <P> byte[] printAllAsBytes(P p) {
        return this.bytes;
    }

    @Override
    public <P> String printAll(P p) {
        throw new UnsupportedOperationException("Cannot print a binary as a string.");
    }

    @Override
    public <P> String printAllTrimmed(P p) {
        throw new UnsupportedOperationException("Cannot print a binary as a string.");
    }

    @Override
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)((BinaryVisitor)v).visitBinary(this, p);
    }

    public Binary(UUID id, Path sourcePath, Markers markers, byte[] bytes) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.bytes = bytes;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Binary)) {
            return false;
        }
        Binary other = (Binary)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }

    @NonNull
    public String toString() {
        return "Binary(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", bytes=" + Arrays.toString(this.getBytes()) + ")";
    }

    @NonNull
    public Binary withId(UUID id) {
        return this.id == id ? this : new Binary(id, this.sourcePath, this.markers, this.bytes);
    }

    @Override
    @NonNull
    public Binary withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new Binary(this.id, sourcePath, this.markers, this.bytes);
    }

    @NonNull
    public Binary withMarkers(Markers markers) {
        return this.markers == markers ? this : new Binary(this.id, this.sourcePath, markers, this.bytes);
    }

    @NonNull
    public Binary withBytes(byte[] bytes) {
        return this.bytes == bytes ? this : new Binary(this.id, this.sourcePath, this.markers, bytes);
    }
}

