/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class StringUtils {
    private static final FileSystem FS = FileSystems.getDefault();

    private StringUtils() {
    }

    public static String trimIndentPreserveCRLF(String text) {
        return StringUtils.trimIndent(text.replace('\r', '\u23ce')).replace('\u23ce', '\r');
    }

    public static String trimIndent(String text) {
        int indentLevel = StringUtils.indentLevel(text);
        StringBuilder trimmed = new StringBuilder();
        AtomicBoolean dropWhile = new AtomicBoolean(false);
        int[] charArray = text.replaceAll("\\s+$", "").chars().filter(c -> {
            dropWhile.set(dropWhile.get() || c != 10 && c != 13);
            return dropWhile.get();
        }).toArray();
        for (int i = 0; i < charArray.length; ++i) {
            int j;
            boolean nonWhitespaceEncountered = false;
            for (j = i; j < charArray.length; ++j) {
                int c2 = charArray[j];
                if (j - i >= indentLevel || (nonWhitespaceEncountered |= !Character.isWhitespace(c2))) {
                    trimmed.append((char)c2);
                }
                if (c2 == 13 || c2 == 10) break;
            }
            i = j;
        }
        return trimmed.toString();
    }

    static int indentLevel(String text) {
        Stream<String> lines = Arrays.stream(text.replaceAll("\\s+$", "").split("\\r?\\n"));
        AtomicBoolean dropWhile = new AtomicBoolean(false);
        AtomicBoolean takeWhile = new AtomicBoolean(true);
        SortedMap indentFrequencies = lines.filter(l -> {
            dropWhile.set(dropWhile.get() || !l.isEmpty());
            return dropWhile.get();
        }).map(l -> {
            takeWhile.set(true);
            return (int)l.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                return takeWhile.get();
            }).count();
        }).collect(Collectors.groupingBy(Function.identity(), TreeMap::new, Collectors.counting()));
        return StringUtils.mostCommonIndent(indentFrequencies);
    }

    public static int mostCommonIndent(SortedMap<Integer, Long> indentFrequencies) {
        TreeMap<Integer, Integer> indentFrequencyAsDivisors = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Long> indentFrequency : indentFrequencies.entrySet()) {
            int freq;
            int indent = indentFrequency.getKey();
            switch (indent) {
                case 0: {
                    freq = indentFrequency.getValue().intValue();
                    break;
                }
                case 1: {
                    freq = (int)indentFrequencies.tailMap(indent).values().stream().mapToLong(l -> l).sum();
                    break;
                }
                default: {
                    freq = (int)indentFrequencies.tailMap(indent).entrySet().stream().filter(inF -> StringUtils.gcd((Integer)inF.getKey(), indent) != 0).mapToLong(Map.Entry::getValue).sum();
                }
            }
            indentFrequencyAsDivisors.put(indent, freq);
        }
        if (indentFrequencies.getOrDefault(0, 0L) > 1L) {
            return 0;
        }
        return indentFrequencyAsDivisors.entrySet().stream().max((e1, e2) -> {
            int valCompare = ((Integer)e1.getValue()).compareTo((Integer)e2.getValue());
            return valCompare != 0 ? valCompare : ((Integer)e1.getKey() == 0 ? -1 : ((Integer)e2.getKey()).compareTo((Integer)e1.getKey()));
        }).map(Map.Entry::getKey).orElse(0);
    }

    static int gcd(int n1, int n2) {
        return n2 == 0 ? n1 : StringUtils.gcd(n2, n1 % n2);
    }

    public static boolean isBlank(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String readFully(InputStream inputStream) {
        String string;
        block9: {
            InputStream is = inputStream;
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((n = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, n);
                }
                byte[] bytes = bos.toByteArray();
                string = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String capitalize(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    public static String uncapitalize(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }

    public static boolean containsOnlyWhitespaceAndComments(String text) {
        int i = 0;
        char[] chars = text.toCharArray();
        boolean inSingleLineComment = false;
        boolean inMultilineComment = false;
        block10: while (i < chars.length) {
            char c = chars[i];
            if (inSingleLineComment && c == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (i < chars.length - 1) {
                String s;
                switch (s = String.valueOf(c) + chars[i + 1]) {
                    case "//": {
                        inSingleLineComment = true;
                        i += 2;
                        continue block10;
                    }
                    case "/*": {
                        inMultilineComment = true;
                        i += 2;
                        continue block10;
                    }
                    case "*/": {
                        inMultilineComment = false;
                        i += 2;
                        continue block10;
                    }
                }
            }
            if (!(inSingleLineComment || inMultilineComment || Character.isWhitespace(c))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int indexOfNonWhitespace(String text) {
        return StringUtils.indexOf(text, it -> it.charValue() != ' ' && it.charValue() != '\t' && it.charValue() != '\n' && it.charValue() != '\r');
    }

    public static int indexOf(String text, Predicate<Character> test) {
        for (int i = 0; i < text.length(); ++i) {
            if (!test.test(Character.valueOf(text.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    public static int countOccurrences(@NonNull String text, @NonNull String substring) {
        if (text.isEmpty() || substring.isEmpty()) {
            return 0;
        }
        int count = 0;
        int index = text.indexOf(substring);
        while (index >= 0) {
            ++count;
            index = text.indexOf(substring, index + substring.length());
        }
        return count;
    }

    public static String replaceFirst(@NonNull String text, @NonNull String match, @NonNull String replacement) {
        int start = text.indexOf(match);
        if (match.isEmpty() || text.isEmpty() || start == -1) {
            return text;
        }
        StringBuilder newValue = new StringBuilder(text.length());
        newValue.append(text, 0, start);
        newValue.append(replacement);
        int end = start + match.length();
        if (end < text.length()) {
            newValue.append(text, end, text.length());
        }
        return newValue.toString();
    }

    public static String repeat(String s, int count) {
        int copied;
        if (count == 1) {
            return s;
        }
        byte[] value = s.getBytes();
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single);
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple);
    }

    public static boolean matchesGlob(@Nullable String value, @Nullable String globPattern) {
        if ("*".equals(globPattern)) {
            return true;
        }
        if (null == globPattern) {
            return false;
        }
        if (null == value) {
            value = "";
        }
        PathMatcher pm = FS.getPathMatcher("glob:" + globPattern);
        Path path = Paths.get("", new String[0]);
        if (value.contains("/")) {
            String[] parts = value.split("/");
            if (parts.length > 1) {
                int len = parts.length;
                for (int i = 0; i < len; ++i) {
                    path = Paths.get("", Arrays.copyOfRange(parts, i, parts.length));
                    if (StringUtils.isBlank(parts[i])) {
                        continue;
                    }
                    break;
                }
            } else {
                path = Paths.get(parts[0], new String[0]);
            }
        } else {
            path = Paths.get(value, new String[0]);
        }
        return pm.matches(path);
    }

    public static String indent(String text) {
        StringBuilder indent = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == '\n' || c == '\r') {
                return indent.toString();
            }
            if (!Character.isWhitespace(c)) {
                return indent.toString();
            }
            indent.append(c);
        }
        return indent.toString();
    }

    public static String greatestCommonMargin(String multiline) {
        String gcm = null;
        StringBuilder margin = new StringBuilder();
        boolean skipRestOfLine = false;
        char[] charArray = multiline.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\n') {
                if (i < charArray.length - 1 && charArray[i + 1] == '\n') {
                    ++i;
                    continue;
                }
                if (i > 0) {
                    if (margin.length() == 0) {
                        return "";
                    }
                    gcm = StringUtils.commonMargin(gcm, margin);
                    margin = new StringBuilder();
                }
                skipRestOfLine = false;
                continue;
            }
            if (Character.isWhitespace(c) && !skipRestOfLine) {
                margin.append(c);
                continue;
            }
            skipRestOfLine = true;
        }
        return gcm == null ? "" : gcm;
    }

    public static String commonMargin(@Nullable CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            String s = s2.toString();
            return s.substring(s.lastIndexOf(10) + 1);
        }
        for (int i = 0; i < s1.length() && i < s2.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i) && Character.isWhitespace(s1.charAt(i))) continue;
            return s1.toString().substring(0, i);
        }
        return s2.length() < s1.length() ? s2.toString() : s1.toString();
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String aspectjNameToPattern(String name) {
        return name.replace("$", "\\$").replace("[", "\\[").replace("]", "\\]").replaceAll("([^.]*)\\.([^.]*)", "$1\\.$2").replace("*", "[^.]*").replace("..", "\\.(.+\\.)?");
    }
}

