/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.PolyglotExport;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.NullUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.scheduling.ForkJoinScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
@PolyglotExport(typeScript="Recipe", llvm="Recipe")
public abstract class Recipe {
    public static final String PANIC = "__AHHH_PANIC!!!__";
    private static final Logger logger = LoggerFactory.getLogger(Recipe.class);
    public static final TreeVisitor<?, ExecutionContext> NOOP = new TreeVisitor<Tree, ExecutionContext>(){

        @Override
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return tree;
        }
    };
    @JsonIgnore
    private final List<Recipe> recipeList = new CopyOnWriteArrayList<Recipe>();

    @JsonProperty(value="@c")
    public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    @Incubating(since="7.18.0")
    public static Recipe noop() {
        return new Recipe(){

            @Override
            public String getDisplayName() {
                return "Do nothing";
            }

            @Override
            protected TreeVisitor<?, ExecutionContext> getVisitor() {
                return NOOP;
            }
        };
    }

    @Language(value="markdown")
    public abstract String getDisplayName();

    @Language(value="markdown")
    public String getDescription() {
        return "";
    }

    public Set<String> getTags() {
        return Collections.emptySet();
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return null;
    }

    public final RecipeDescriptor getDescriptor() {
        return RecipeIntrospectionUtils.recipeDescriptorFromRecipe(this);
    }

    public List<String> getLanguages() {
        return Collections.emptyList();
    }

    @Incubating(since="7.3.0")
    public boolean causesAnotherCycle() {
        return false;
    }

    public Recipe doNext(Recipe recipe) {
        this.recipeList.add(recipe);
        return this;
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return NOOP;
    }

    @Nullable
    @Incubating(since="7.2.0")
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return null;
    }

    @Nullable
    @Incubating(since="7.4.0")
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return null;
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return before;
    }

    public final List<Result> run(List<? extends SourceFile> before) {
        return this.run(before, new InMemoryExecutionContext());
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx) {
        return this.run(before, ctx, 3);
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles) {
        return this.run(before, ctx, ForkJoinScheduler.common(), maxCycles, 1);
    }

    @Incubating(since="7.3.0")
    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx, RecipeScheduler recipeScheduler, int maxCycles, int minCycles) {
        return recipeScheduler.scheduleRun(this, before, ctx, maxCycles, minCycles);
    }

    @Incubating(since="7.0.0")
    public Validated validate(ExecutionContext ctx) {
        return this.validate();
    }

    public Validated validate() {
        Validated validated = Validated.none();
        List<Field> requiredFields = NullUtils.findNonNullFields(this.getClass());
        for (Field field : requiredFields) {
            try {
                validated = validated.and(Validated.required(field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Unable to validate the field [{}] on the class [{}]", (Object)field.getName(), (Object)this.getClass().getName());
            }
        }
        return validated;
    }

    @Incubating(since="7.0.0")
    public final Collection<Validated> validateAll(ExecutionContext ctx) {
        return this.validateAll(ctx, new ArrayList<Validated>());
    }

    public final Collection<Validated> validateAll() {
        return this.validateAll(new InMemoryExecutionContext(), new ArrayList<Validated>());
    }

    private Collection<Validated> validateAll(ExecutionContext ctx, Collection<Validated> acc) {
        acc.add(this.validate(ctx));
        for (Recipe recipe : this.recipeList) {
            recipe.validateAll(ctx, acc);
        }
        return acc;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

