/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainTextVisitor;

public class PlainText
implements SourceFile,
Tree {
    private final UUID id;
    private Markers markers;
    private final String text;

    public PlainText(UUID id, Markers markers, String text) {
        this.id = id;
        this.markers = markers;
        this.text = text;
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof PlainTextVisitor;
    }

    @Override
    public Path getSourcePath() {
        return Paths.get("text.txt", new String[0]);
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public PlainText withMarkers(Markers markers) {
        this.markers = markers;
        return this;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public <P> String print(TreePrinter<P> printer, P p) {
        return this.print(p);
    }

    public PlainText withText(String toText) {
        return new PlainText(this.id, this.markers, toText);
    }

    @Override
    public <P> String print(P p) {
        return this.text;
    }
}

