/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.shaded.jgit.diff.DiffEntry;
import org.openrewrite.shaded.jgit.diff.DiffFormatter;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.openrewrite.shaded.jgit.internal.storage.dfs.InMemoryRepository;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.lib.ObjectInserter;

public class Result {
    @Nullable
    private final SourceFile before;
    @Nullable
    private final SourceFile after;
    private final Set<Recipe> recipesThatMadeChanges;

    public Result(@Nullable SourceFile before, @Nullable SourceFile after, Set<Recipe> recipesThatMadeChanges) {
        this.before = before;
        this.after = after;
        this.recipesThatMadeChanges = recipesThatMadeChanges;
    }

    public String diff() {
        return this.diff(TreePrinter.identity());
    }

    public String diff(TreePrinter<?> treePrinter) {
        return this.diff(null, treePrinter);
    }

    public String diff(@Nullable Path relativeTo, TreePrinter<?> treePrinter) {
        Path sourcePath = this.after != null ? this.after.getSourcePath() : (this.before != null ? this.before.getSourcePath() : (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + System.nanoTime()));
        return new InMemoryDiffEntry(sourcePath, relativeTo, this.before == null ? "" : this.before.print(), this.after == null ? "" : this.after.print(treePrinter, null), this.recipesThatMadeChanges).getDiff();
    }

    public String toString() {
        return this.diff();
    }

    @Nullable
    public SourceFile getBefore() {
        return this.before;
    }

    @Nullable
    public SourceFile getAfter() {
        return this.after;
    }

    public Set<Recipe> getRecipesThatMadeChanges() {
        return this.recipesThatMadeChanges;
    }

    static class InMemoryDiffEntry
    extends DiffEntry {
        private final InMemoryRepository repo;
        private final Set<Recipe> recipesThatMadeChanges;

        InMemoryDiffEntry(Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges) {
            this.changeType = DiffEntry.ChangeType.MODIFY;
            this.recipesThatMadeChanges = recipesThatMadeChanges;
            Path relativePath = relativeTo == null ? filePath : relativeTo.relativize(filePath);
            this.oldPath = relativePath.toString();
            this.newPath = relativePath.toString();
            try {
                this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
                ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();
                this.oldId = inserter.insert(3, oldSource.getBytes()).abbreviate(40);
                this.newId = inserter.insert(3, newSource.getBytes()).abbreviate(40);
                inserter.flush();
                this.oldMode = FileMode.REGULAR_FILE;
                this.newMode = FileMode.REGULAR_FILE;
                this.repo.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        String getDiff() {
            if (this.oldId.equals(this.newId)) {
                return "";
            }
            ByteArrayOutputStream patch = new ByteArrayOutputStream();
            DiffFormatter formatter = new DiffFormatter(patch);
            formatter.setRepository(this.repo);
            try {
                formatter.format(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String diff = patch.toString();
            AtomicBoolean addedComment = new AtomicBoolean(false);
            return Arrays.stream(diff.split("\n")).map(l -> {
                if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                    addedComment.set(true);
                    return l + this.recipesThatMadeChanges.stream().map(Recipe::getName).sorted().collect(Collectors.joining(", ", " ", ""));
                }
                return l;
            }).collect(Collectors.joining("\n")) + "\n";
        }
    }
}

