/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public class Cursor {
    @Nullable
    private final Cursor parent;
    private final Object value;
    @Nullable
    private Map<String, Object> messages;

    public Cursor(@Nullable Cursor parent, Object value) {
        this.parent = parent;
        this.value = value;
    }

    public Cursor getRoot() {
        Cursor c = this;
        while (c.parent != null) {
            c = c.parent;
        }
        return c;
    }

    public Iterator<Object> getPath() {
        return new CursorIterator(this);
    }

    public Iterator<Object> getPath(Predicate<Object> filter) {
        return new CursorIterator(this, filter);
    }

    public Stream<Object> getPathAsStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getPath(), 0), false);
    }

    public Stream<Object> getPathAsStream(Predicate<Object> filter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getPath(filter), 1024), false);
    }

    @Nullable
    public <T> T firstEnclosing(Class<T> tClass) {
        CursorIterator iter = new CursorIterator(this);
        while (iter.hasNext()) {
            Object value = iter.next();
            if (!tClass.isInstance(value)) continue;
            return (T)value;
        }
        return null;
    }

    public <T> T firstEnclosingOrThrow(Class<T> tClass) {
        T firstEnclosing = this.firstEnclosing(tClass);
        if (firstEnclosing == null) {
            throw new IllegalStateException("Expected to find enclosing " + tClass.getSimpleName());
        }
        return firstEnclosing;
    }

    public String toString() {
        return "Cursor{" + StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getPath(), 0), false).map(t -> t instanceof Tree ? t.getClass().getSimpleName() : t.toString()).collect(Collectors.joining("->")) + "}";
    }

    public Cursor dropParentUntil(Predicate<Object> valuePredicate) {
        Cursor cursor = this.parent;
        while (cursor != null && !valuePredicate.test(cursor.value)) {
            cursor = cursor.parent;
        }
        if (cursor == null) {
            throw new IllegalStateException("Expected to find a matching parent for " + this);
        }
        return cursor;
    }

    public Cursor dropParentWhile(Predicate<Object> valuePredicate) {
        Cursor cursor = this.parent;
        while (cursor != null && valuePredicate.test(cursor.value)) {
            cursor = cursor.parent;
        }
        if (cursor == null) {
            throw new IllegalStateException("Expected to find a matching parent for " + this);
        }
        return cursor;
    }

    @Nullable
    @Incubating(since="7.0.0")
    public Cursor getParent(int levels) {
        Cursor cursor = this;
        for (int i = 0; i < levels && cursor != null; ++i) {
            cursor = cursor.parent;
        }
        return cursor;
    }

    @Nullable
    public Cursor getParent() {
        return this.getParent(1);
    }

    @Incubating(since="7.0.0")
    public Cursor getParentOrThrow(int levels) {
        Cursor parent = this.getParent(levels);
        if (parent == null) {
            throw new IllegalStateException("Expected to find a parent for " + this);
        }
        return parent;
    }

    public Cursor getParentOrThrow() {
        return this.getParentOrThrow(1);
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public boolean isScopeInPath(Tree scope) {
        return this.value instanceof Tree && ((Tree)this.value).getId().equals(scope.getId()) || this.getPathAsStream().anyMatch(p -> p instanceof Tree && ((Tree)p).getId().equals(scope.getId()));
    }

    @Incubating(since="7.0.0")
    public void putMessageOnFirstEnclosing(Class<?> enclosing, String key, Object value) {
        if (enclosing.isInstance(this.getValue())) {
            this.putMessage(key, value);
        } else if (this.parent != null) {
            this.parent.putMessageOnFirstEnclosing(enclosing, key, value);
        }
    }

    @Incubating(since="7.0.0")
    public void putMessage(String key, Object value) {
        if (this.messages == null) {
            this.messages = new HashMap<String, Object>();
        }
        this.messages.put(key, value);
    }

    @Incubating(since="7.1.0")
    public <T> T computeMessageIfAbsent(String key, Function<String, ? extends T> mappingFunction) {
        if (this.messages == null) {
            this.messages = new HashMap<String, Object>();
        }
        T t = this.messages.computeIfAbsent(key, mappingFunction);
        return t;
    }

    @Nullable
    @Incubating(since="7.0.0")
    public <T> T getNearestMessage(String key) {
        Object t = this.messages == null ? null : this.messages.get(key);
        return (T)(t == null && this.parent != null ? this.parent.getNearestMessage(key) : t);
    }

    @Nullable
    @Incubating(since="7.0.0")
    public <T> T pollNearestMessage(String key) {
        Object t = this.messages == null ? null : this.messages.remove(key);
        return (T)(t == null && this.parent != null ? this.parent.pollNearestMessage(key) : t);
    }

    @Nullable
    @Incubating(since="7.0.0")
    public <T> T getMessage(String key) {
        return (T)(this.messages == null ? null : this.messages.get(key));
    }

    @Nullable
    @Incubating(since="7.0.0")
    public <T> T pollMessage(String key) {
        return (T)(this.messages == null ? null : this.messages.remove(key));
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cursor)) {
            return false;
        }
        Cursor other = (Cursor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cursor this$parent = this.getParent();
        Cursor other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Cursor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private static class CursorIterator
    implements Iterator<Object> {
        private Cursor cursor;
        private Predicate<Object> filter = v -> true;

        private CursorIterator(Cursor cursor) {
            this.cursor = cursor;
        }

        private CursorIterator(Cursor cursor, Predicate<Object> filter) {
            this.cursor = cursor;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            Cursor c = this.cursor;
            while (c != null) {
                if (this.filter.test(c.value)) {
                    return true;
                }
                c = c.parent;
            }
            return false;
        }

        @Override
        public Object next() {
            while (this.cursor != null) {
                Object v = this.cursor.value;
                if (this.filter.test(v)) {
                    this.cursor = this.cursor.parent;
                    return v;
                }
                this.cursor = this.cursor.parent;
            }
            throw new NoSuchElementException();
        }
    }
}

