/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

@Incubating(since="7.0.0")
public interface SearchResult
extends Marker {
    @Nullable
    public String getDescription();

    public static TreePrinter<Void> printer(final String markerText, final String markerTextWithDescription) {
        return new TreePrinter<Void>(){
            private SearchResult marker;
            private Integer mark;

            @Override
            public void doBefore(Tree tree, StringBuilder printerAcc, Void unused) {
                if (tree instanceof SearchResult) {
                    this.marker = (SearchResult)tree;
                    this.mark = printerAcc.length();
                }
            }

            @Override
            public void doAfter(Tree tree, StringBuilder printerAcc, Void unused) {
                if (this.mark != null) {
                    printerAcc.delete(this.mark, printerAcc.length());
                    printerAcc.append(this.marker.getDescription() == null ? markerText : String.format(markerTextWithDescription, this.marker.getDescription()));
                    this.mark = null;
                }
            }
        };
    }
}

