/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public interface Tree {
    public static UUID randomId() {
        return UUID.randomUUID();
    }

    public UUID getId();

    @Nullable
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return v.defaultValue(this, p);
    }

    public <P> boolean isAcceptable(TreeVisitor<?, P> var1, P var2);

    public <P> String print(TreePrinter<P> var1, P var2);

    default public <P> String print(P p) {
        return this.print(TreePrinter.identity(), p);
    }

    default public String print() {
        return this.print(TreePrinter.identity(), new Object());
    }

    default public <P> String printTrimmed(TreePrinter<P> printer, P p) {
        return StringUtils.trimIndent(this.print(printer, p).trim());
    }

    default public <P> String printTrimmed(P p) {
        return this.printTrimmed(TreePrinter.identity(), p);
    }

    default public String printTrimmed() {
        return this.printTrimmed(TreePrinter.identity(), new Object());
    }

    default public boolean isScope(@Nullable Tree tree) {
        return tree != null && tree.getId().equals(this.getId());
    }
}

