/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openrewrite.internal.lang.Nullable;

public interface ExecutionContext {
    public void putMessage(String var1, Object var2);

    @Nullable
    public <T> T getMessage(String var1);

    default public <V, T> T computeMessage(String key, V value, T defaultValue, BiFunction<V, ? super T, ? extends T> remappingFunction) {
        T oldMessage = this.getMessage(key);
        if (oldMessage == null) {
            oldMessage = defaultValue;
        }
        T newMessage = remappingFunction.apply(value, oldMessage);
        this.putMessage(key, newMessage);
        return newMessage;
    }

    default public <V, T, C extends Collection<V>> C putMessageInCollection(String key, V value, Supplier<C> newCollection) {
        return (C)this.computeMessage(key, value, (Collection)newCollection.get(), (v, acc) -> {
            Collection c = (Collection)newCollection.get();
            c.addAll(acc);
            c.add(value);
            return c;
        });
    }

    default public <T> Set<T> putMessageInSet(String key, T value) {
        return this.putMessageInCollection(key, value, HashSet::new);
    }

    default public <T> T getMessage(String key, T defaultValue) {
        T t = this.getMessage(key);
        return t == null ? defaultValue : t;
    }

    @Nullable
    public <T> T pollMessage(String var1);

    default public <T> T pollMessage(String key, T defaultValue) {
        T t = this.pollMessage(key);
        return t == null ? defaultValue : t;
    }

    public Consumer<Throwable> getOnError();
}

