/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

public class CategoryTree<G> {
    private final Object lock = new Object();
    private final CategoryDescriptor descriptor;
    private final Collection<CategoryTree<G>> subtrees = new ArrayList<CategoryTree<G>>();
    private Map<G, Collection<RecipeDescriptor>> recipesByGroup = new HashMap<G, Collection<RecipeDescriptor>>();

    private CategoryTree(CategoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static <G> CategoryTree<G> build() {
        return new CategoryTree<G>(new CategoryDescriptor("Root", "", "", Collections.emptySet()));
    }

    public CategoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Integer getRecipeCount() {
        return this.recipesByGroup.values().stream().mapToInt(Collection::size).sum() + this.subtrees.stream().mapToInt(CategoryTree::getRecipeCount).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CategoryTree<G> getCategory(String subcategory) {
        String packageName = this.descriptor.getPackageName();
        Object object = this.lock;
        synchronized (object) {
            if (subcategory.equals("core") && !this.recipesByGroup.isEmpty()) {
                return this.syntheticCore();
            }
            for (CategoryTree<G> t : this.subtrees) {
                String tPackage = t.getDescriptor().getPackageName();
                int endIndex = tPackage.indexOf(46, packageName.length() + 1);
                String test = tPackage.substring(packageName.isEmpty() ? 0 : packageName.length() + 1, endIndex < 0 ? tPackage.length() : endIndex);
                if (!subcategory.equals(test)) continue;
                return t;
            }
        }
        return null;
    }

    @Nullable
    public CategoryTree<G> getCategory(String ... subcategories) {
        CategoryTree<G> acc = this;
        for (String subcategory : subcategories) {
            if (acc == null) {
                return null;
            }
            acc = acc.getCategory(subcategory);
        }
        return acc;
    }

    public CategoryTree<G> getCategoryOrThrow(String subcategory) {
        CategoryTree<G> subtree = this.getCategory(subcategory);
        if (subtree == null) {
            throw new IllegalArgumentException("No subcategory of " + this.descriptor.getPackageName() + " named '" + subcategory + "'");
        }
        return subtree;
    }

    public CategoryTree<G> getCategoryOrThrow(String ... subcategories) {
        CategoryTree<G> acc = this;
        for (String subcategory : subcategories) {
            acc = acc.getCategoryOrThrow(subcategory);
        }
        return acc;
    }

    @Nullable
    public RecipeDescriptor getRecipe(String id) {
        if (id.contains(".")) {
            String[] split = id.split("\\.", 2);
            CategoryTree<G> subcategory = this.getCategory(split[0]);
            return subcategory == null ? null : subcategory.getRecipe(split[1]);
        }
        return this.recipesByGroup.values().stream().flatMap(Collection::stream).filter(r -> r.getName().substring(r.getName().lastIndexOf(46) + 1).equals(id)).findAny().orElse(null);
    }

    @Nullable
    public G getRecipeGroup(String id) {
        if (id.contains(".")) {
            String[] split = id.split("\\.", 2);
            CategoryTree<G> subcategory = this.getCategory(split[0]);
            return subcategory == null ? null : (G)subcategory.getRecipeGroup(split[1]);
        }
        return this.recipesByGroup.entrySet().stream().filter(g -> ((Collection)g.getValue()).stream().anyMatch(r -> r.getName().substring(r.getName().lastIndexOf(46) + 1).equals(id))).map(Map.Entry::getKey).findAny().orElse(null);
    }

    public CategoryTree<G> putAll(G group, Environment environment) {
        return this.putAll(group, environment.listRecipeDescriptors(), environment.listCategoryDescriptors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CategoryTree<G> putAll(G group, Iterable<RecipeDescriptor> recipes, Iterable<CategoryDescriptor> categories) {
        Object object = this.lock;
        synchronized (object) {
            this.removeAll(group);
            for (RecipeDescriptor recipe : recipes) {
                this.add(group, recipe, categories);
            }
        }
        return this;
    }

    private void add(G group, RecipeDescriptor recipe, Iterable<CategoryDescriptor> categories) {
        String packageName;
        String category = recipe.getName().substring(0, recipe.getName().lastIndexOf(46));
        if (category.equals(packageName = this.descriptor.getPackageName())) {
            this.recipesByGroup.computeIfAbsent(group, g -> new ArrayList()).add(recipe);
        } else if (category.startsWith(packageName)) {
            CategoryTree<G> subtree = null;
            for (CategoryTree<G> s : this.subtrees) {
                if (!category.startsWith(s.descriptor.getPackageName())) continue;
                subtree = s;
                break;
            }
            if (subtree == null) {
                int endIndex = category.indexOf(46, packageName.length() + 1);
                String subcategoryPackage = endIndex < 0 ? category : packageName + category.substring(packageName.length(), endIndex);
                CategoryDescriptor subcategoryDescriptor = null;
                for (CategoryDescriptor categoryDescriptor : categories) {
                    if (!categoryDescriptor.getPackageName().equals(subcategoryPackage)) continue;
                    subcategoryDescriptor = categoryDescriptor;
                    break;
                }
                if (subcategoryDescriptor == null) {
                    subcategoryDescriptor = new CategoryDescriptor(StringUtils.capitalize(subcategoryPackage.substring(subcategoryPackage.lastIndexOf(46) + 1)), subcategoryPackage, "", Collections.emptySet());
                }
                subtree = new CategoryTree<G>(subcategoryDescriptor);
                this.subtrees.add(subtree);
            }
            super.add(group, recipe, categories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CategoryTree<G> removeAll(G group) {
        Object object = this.lock;
        synchronized (object) {
            this.recipesByGroup.remove(group);
            for (CategoryTree<G> subtree : this.subtrees) {
                subtree.removeAll(group);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RecipeDescriptor> getRecipes() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.subtrees.isEmpty()) {
                return Collections.emptyList();
            }
            return this.recipesByGroup.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<G, Collection<RecipeDescriptor>> getRecipesByGroup() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(new HashMap<G, Collection<RecipeDescriptor>>(this.recipesByGroup));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CategoryTree<G>> getSubtrees() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.subtrees.isEmpty() && !this.recipesByGroup.isEmpty()) {
                ArrayList<CategoryTree<G>> subtreesAndCore = new ArrayList<CategoryTree<G>>(this.subtrees);
                subtreesAndCore.add(this.syntheticCore());
                return subtreesAndCore;
            }
            return this.subtrees;
        }
    }

    @NotNull
    private CategoryTree<G> syntheticCore() {
        CategoryTree<G> core = new CategoryTree<G>(new CategoryDescriptor("Core", this.descriptor.getPackageName() + ".core", "", Collections.emptySet()));
        core.recipesByGroup = this.recipesByGroup;
        return core;
    }
}

