/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.io.FilenameUtils;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public class PolyglotUtils {
    public static final String JS = "js";
    public static final String PYTHON = "python";
    public static final String PY = "py";
    public static final String PYC = "pyc";
    public static final String LLVM = "llvm";

    public static String getLanguage(String source) {
        String suffix;
        switch (suffix = FilenameUtils.getExtension((String)source)) {
            case "js": {
                return JS;
            }
            case "py": 
            case "pyc": {
                return PYTHON;
            }
        }
        return LLVM;
    }

    public static String getLanguage(Source source) {
        return PolyglotUtils.getLanguage(source.getPath());
    }

    public static String getName(Value value) {
        if (value.getMetaObject() == null) {
            return "undefined";
        }
        try {
            return value.getMetaSimpleName();
        }
        catch (UnsupportedOperationException e) {
            return value.getMetaObject().toString();
        }
    }

    public static Optional<Value> getValue(Value value, String memberKey) {
        return Optional.ofNullable(value.getMember(memberKey));
    }

    @Nullable
    public static <O> O invokeMemberOrElse(Value value, String member, @Nullable Supplier<O> superFn) {
        return (O)(value.canInvokeMember(member) ? value.invokeMember(member, new Object[0]) : (superFn != null ? (Value)superFn.get() : null));
    }

    public static <TREE extends Tree, CTX> TREE invokeMemberOrElse(Value value, String member, @Nullable TREE tree, CTX ctx, BiFunction<TREE, CTX, TREE> superFn) {
        return (TREE)(value.canInvokeMember(member) ? (Tree)value.invokeMember(member, new Object[]{Value.asValue(tree), Value.asValue(ctx)}).as(Tree.class) : (Tree)superFn.apply(tree, ctx));
    }
}

