/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.regex.Pattern;
import org.openrewrite.Incubating;
import org.openrewrite.internal.StringUtils;

@Incubating(since="7.17.0")
public enum NameCaseConvention {
    LOWER_HYPHEN,
    LOWER_UNDERSCORE,
    LOWER_CAMEL,
    UPPER_CAMEL,
    UPPER_UNDERSCORE;

    private static final Pattern CAMEL_CASE_SPLIT;

    public String format(String str) {
        return NameCaseConvention.format(this, str);
    }

    public static String format(NameCaseConvention convention, String str) {
        switch (convention) {
            case LOWER_HYPHEN: {
                return NameCaseConvention.lowerHyphen(str);
            }
            case LOWER_UNDERSCORE: {
                return NameCaseConvention.lowerUnderscore(str);
            }
            case LOWER_CAMEL: {
                return NameCaseConvention.toCamelCase(str, true);
            }
            case UPPER_CAMEL: {
                return NameCaseConvention.toCamelCase(str, false);
            }
            case UPPER_UNDERSCORE: {
                return NameCaseConvention.upperUnderscore(str);
            }
        }
        return str;
    }

    public boolean matches(String str) {
        return NameCaseConvention.matches(this, str);
    }

    public static boolean matches(NameCaseConvention convention, String str) {
        return str.matches(NameCaseConvention.format(convention, str));
    }

    public static boolean equalsRelaxedBinding(String str0, String str1) {
        return LOWER_CAMEL.format(str0).equals(LOWER_CAMEL.format(str1));
    }

    private static String lowerHyphen(String str) {
        return NameCaseConvention.nameCaseJoiner(str.replace('_', '-').replace(' ', '-'), true, '-');
    }

    private static String lowerUnderscore(String str) {
        return NameCaseConvention.nameCaseJoiner(str.replace('-', '_').replace(' ', '_'), true, '_').toLowerCase();
    }

    private static String toCamelCase(String str, boolean lowerCaseFirstLetter) {
        StringBuilder sb = new StringBuilder(str.length());
        for (String s : CAMEL_CASE_SPLIT.split(str)) {
            String capitalize = StringUtils.capitalize(s);
            sb.append(capitalize);
        }
        String result = sb.toString();
        if (lowerCaseFirstLetter) {
            return StringUtils.uncapitalize(result);
        }
        return result;
    }

    private static String upperUnderscore(String str) {
        return NameCaseConvention.nameCaseJoiner(str.replace('-', '_').replace(' ', '_'), false, '_').toUpperCase();
    }

    private static String nameCaseJoiner(String str, boolean lowerCaseFirstLetter, char separatorChar) {
        StringBuilder builder = new StringBuilder();
        if (lowerCaseFirstLetter) {
            char[] chars = str.toCharArray();
            boolean first = true;
            char last = '0';
            char secondLast = separatorChar;
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (Character.isLowerCase(c) || !Character.isLetter(c)) {
                    first = false;
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            builder.append(separatorChar);
                        }
                        builder.append(c);
                    }
                } else {
                    char lowerCaseChar = Character.toLowerCase(c);
                    if (first) {
                        first = false;
                        builder.append(lowerCaseChar);
                    } else if (Character.isUpperCase(last) || last == '.') {
                        builder.append(lowerCaseChar);
                    } else if (Character.isDigit(last) && (Character.isUpperCase(secondLast) || secondLast == separatorChar)) {
                        builder.append(lowerCaseChar);
                    } else {
                        builder.append(separatorChar).append(lowerCaseChar);
                    }
                }
                if (i > 1) {
                    secondLast = last;
                }
                last = c;
            }
        } else {
            boolean first = true;
            char last = '0';
            for (char c : str.toCharArray()) {
                if (first) {
                    builder.append(c);
                    first = false;
                } else if (Character.isUpperCase(c) && !Character.isUpperCase(last)) {
                    if (c != separatorChar) {
                        builder.append(separatorChar);
                    }
                    builder.append(c);
                } else {
                    if (c == '.') {
                        first = true;
                    }
                    if (c != separatorChar) {
                        if (last == separatorChar) {
                            builder.append(separatorChar);
                        }
                        builder.append(c);
                    }
                }
                last = c;
            }
        }
        return builder.toString();
    }

    static {
        CAMEL_CASE_SPLIT = Pattern.compile("[\\s_-]");
    }
}

