/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.graalvm.polyglot.Value;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.polyglot.PolyglotVisitor;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Polyglot
extends Serializable,
Tree {
    @Override
    public UUID getId();

    public Value getValue();

    default public <T> Optional<T> as(Class<T> targetType) {
        try {
            return Optional.ofNullable(this.getValue().as(targetType));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    @Nullable
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)(v instanceof PolyglotVisitor ? this.acceptPolyglot((PolyglotVisitor)v, p) : v.defaultValue(this, p));
    }

    @Nullable
    default public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
        return (Polyglot)pv.defaultValue(this, p);
    }

    @Override
    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof PolyglotVisitor;
    }

    public static final class ArrayElement
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final int index;
        private final Value value;

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitArrayElement(this, p);
        }

        public ArrayElement(UUID id, Markers markers, int index, Value value) {
            this.id = id;
            this.markers = markers;
            this.index = index;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.ArrayElement(id=" + this.getId() + ", markers=" + this.getMarkers() + ", index=" + this.getIndex() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayElement)) {
                return false;
            }
            ArrayElement other = (ArrayElement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public ArrayElement withId(UUID id) {
            return this.id == id ? this : new ArrayElement(id, this.markers, this.index, this.value);
        }

        @NonNull
        public ArrayElement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayElement(this.id, markers, this.index, this.value);
        }

        @NonNull
        public ArrayElement withIndex(int index) {
            return this.index == index ? this : new ArrayElement(this.id, this.markers, index, this.value);
        }

        @NonNull
        public ArrayElement withValue(Value value) {
            return this.value == value ? this : new ArrayElement(this.id, this.markers, this.index, value);
        }
    }

    public static final class ArrayElements
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final Value value;
        private final List<ArrayElement> elements;

        public ArrayElements(UUID id, Markers markers, Value value) {
            this(id, markers, value, IntStream.range(0, Long.valueOf(value.getArraySize()).intValue()).mapToObj(i -> {
                Value v = value.getArrayElement((long)i);
                return new ArrayElement(Tree.randomId(), Markers.EMPTY, i, v);
            }).collect(Collectors.toList()));
        }

        public ArrayElements(UUID id, Markers markers, Value value, List<ArrayElement> elements) {
            this.id = id;
            this.markers = markers;
            this.value = value;
            this.elements = elements;
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitArrayElements(this, p);
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        public List<ArrayElement> getElements() {
            return this.elements;
        }

        @NonNull
        public String toString() {
            return "Polyglot.ArrayElements(id=" + this.getId() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ", elements=" + this.getElements() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayElements)) {
                return false;
            }
            ArrayElements other = (ArrayElements)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public ArrayElements withId(UUID id) {
            return this.id == id ? this : new ArrayElements(id, this.markers, this.value, this.elements);
        }

        @NonNull
        public ArrayElements withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayElements(this.id, markers, this.value, this.elements);
        }

        @NonNull
        public ArrayElements withValue(Value value) {
            return this.value == value ? this : new ArrayElements(this.id, this.markers, value, this.elements);
        }

        @NonNull
        public ArrayElements withElements(List<ArrayElement> elements) {
            return this.elements == elements ? this : new ArrayElements(this.id, this.markers, this.value, elements);
        }
    }

    public static final class HashEntry
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final String key;
        private final Value value;

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitHashEntry(this, p);
        }

        public HashEntry(UUID id, Markers markers, String key, Value value) {
            this.id = id;
            this.markers = markers;
            this.key = key;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.HashEntry(id=" + this.getId() + ", markers=" + this.getMarkers() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashEntry)) {
                return false;
            }
            HashEntry other = (HashEntry)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public HashEntry withId(UUID id) {
            return this.id == id ? this : new HashEntry(id, this.markers, this.key, this.value);
        }

        @NonNull
        public HashEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new HashEntry(this.id, markers, this.key, this.value);
        }

        @NonNull
        public HashEntry withKey(String key) {
            return this.key == key ? this : new HashEntry(this.id, this.markers, key, this.value);
        }

        @NonNull
        public HashEntry withValue(Value value) {
            return this.value == value ? this : new HashEntry(this.id, this.markers, this.key, value);
        }
    }

    public static final class HashEntries
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final Value value;
        private final Set<String> keys;
        private final List<HashEntry> entries;

        public HashEntries(UUID id, Markers markers, Value value) {
            this(id, markers, value, value.getMemberKeys(), value.getMemberKeys().stream().map(key -> new HashEntry(Tree.randomId(), Markers.EMPTY, (String)key, value.getMember(key))).collect(Collectors.toList()));
        }

        public HashEntries(UUID id, Markers markers, Value value, Set<String> keys, List<HashEntry> entries) {
            this.id = id;
            this.markers = markers;
            this.value = value;
            this.keys = keys;
            this.entries = entries;
        }

        public HashEntries withValue(Value value) {
            if (value == this.getValue()) {
                return this;
            }
            return new HashEntries(Tree.randomId(), this.markers, value);
        }

        public HashEntries withEntries(List<HashEntry> entries) {
            return new HashEntries(Tree.randomId(), this.markers, this.value, entries.stream().map(HashEntry::getKey).collect(Collectors.toSet()), entries);
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitHashEntries(this, p);
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        @NonNull
        public String toString() {
            return "Polyglot.HashEntries(id=" + this.getId() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ", keys=" + this.getKeys() + ", entries=" + this.getEntries() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashEntries)) {
                return false;
            }
            HashEntries other = (HashEntries)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public HashEntries withMarkers(Markers markers) {
            return this.markers == markers ? this : new HashEntries(this.id, markers, this.value, this.keys, this.entries);
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        public List<HashEntry> getEntries() {
            return this.entries;
        }
    }

    public static final class NumberValue
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final Number numberValue;

        @Override
        public Value getValue() {
            return Value.asValue((Object)this.numberValue);
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitNumberValue(this, p);
        }

        public NumberValue(UUID id, Markers markers, Number numberValue) {
            this.id = id;
            this.markers = markers;
            this.numberValue = numberValue;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Number getNumberValue() {
            return this.numberValue;
        }

        @NonNull
        public String toString() {
            return "Polyglot.NumberValue(id=" + this.getId() + ", markers=" + this.getMarkers() + ", numberValue=" + this.getNumberValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NumberValue)) {
                return false;
            }
            NumberValue other = (NumberValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public NumberValue withId(UUID id) {
            return this.id == id ? this : new NumberValue(id, this.markers, this.numberValue);
        }

        @NonNull
        public NumberValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new NumberValue(this.id, markers, this.numberValue);
        }

        @NonNull
        public NumberValue withNumberValue(Number numberValue) {
            return this.numberValue == numberValue ? this : new NumberValue(this.id, this.markers, numberValue);
        }
    }

    public static final class StringValue
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final String stringValue;

        @Override
        public Value getValue() {
            return Value.asValue((Object)this.stringValue);
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitStringValue(this, p);
        }

        public StringValue(UUID id, Markers markers, String stringValue) {
            this.id = id;
            this.markers = markers;
            this.stringValue = stringValue;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        @NonNull
        public String toString() {
            return "Polyglot.StringValue(id=" + this.getId() + ", markers=" + this.getMarkers() + ", stringValue=" + this.getStringValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringValue)) {
                return false;
            }
            StringValue other = (StringValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public StringValue withId(UUID id) {
            return this.id == id ? this : new StringValue(id, this.markers, this.stringValue);
        }

        @NonNull
        public StringValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringValue(this.id, markers, this.stringValue);
        }

        @NonNull
        public StringValue withStringValue(String stringValue) {
            return this.stringValue == stringValue ? this : new StringValue(this.id, this.markers, stringValue);
        }
    }

    public static final class Instantiable
    implements Member {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final Value value;

        public Instance instantiate(Object ... args) {
            Value v;
            try {
                v = this.value.newInstance(args);
                v.getMetaObject().putMember("member", (Object)this.name);
            }
            catch (Throwable t) {
                v = Value.asValue((Object)t);
            }
            return new Instance(Tree.randomId(), Markers.EMPTY, this.value.getMetaSimpleName(), v);
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitInstantiable(this, p);
        }

        public Instantiable(UUID id, Markers markers, String name, Value value) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.Instantiable(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Instantiable)) {
                return false;
            }
            Instantiable other = (Instantiable)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Instantiable withId(UUID id) {
            return this.id == id ? this : new Instantiable(id, this.markers, this.name, this.value);
        }

        @NonNull
        public Instantiable withMarkers(Markers markers) {
            return this.markers == markers ? this : new Instantiable(this.id, markers, this.name, this.value);
        }

        @NonNull
        public Instantiable withName(String name) {
            return this.name == name ? this : new Instantiable(this.id, this.markers, name, this.value);
        }

        @Override
        @NonNull
        public Instantiable withValue(Value value) {
            return this.value == value ? this : new Instantiable(this.id, this.markers, this.name, value);
        }
    }

    public static final class Instance
    implements Member {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final Value value;

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitInstance(this, p);
        }

        public Instance(UUID id, Markers markers, String name, Value value) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.Instance(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Instance)) {
                return false;
            }
            Instance other = (Instance)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Instance withId(UUID id) {
            return this.id == id ? this : new Instance(id, this.markers, this.name, this.value);
        }

        @NonNull
        public Instance withMarkers(Markers markers) {
            return this.markers == markers ? this : new Instance(this.id, markers, this.name, this.value);
        }

        @NonNull
        public Instance withName(String name) {
            return this.name == name ? this : new Instance(this.id, this.markers, name, this.value);
        }

        @Override
        @NonNull
        public Instance withValue(Value value) {
            return this.value == value ? this : new Instance(this.id, this.markers, this.name, value);
        }
    }

    public static final class Error
    implements Polyglot {
        private final UUID id;
        private final Markers markers;
        private final Value value;

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitError(this, p);
        }

        public Error(UUID id, Markers markers, Value value) {
            this.id = id;
            this.markers = markers;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.Error(id=" + this.getId() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Error withId(UUID id) {
            return this.id == id ? this : new Error(id, this.markers, this.value);
        }

        @NonNull
        public Error withMarkers(Markers markers) {
            return this.markers == markers ? this : new Error(this.id, markers, this.value);
        }

        @NonNull
        public Error withValue(Value value) {
            return this.value == value ? this : new Error(this.id, this.markers, value);
        }
    }

    public static final class Executable
    implements Member {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final Value value;

        public Instance execute(Object ... args) {
            Value v;
            String name = this.value.getMetaSimpleName();
            try {
                v = this.value.execute(args);
            }
            catch (Throwable t) {
                v = Value.asValue((Object)t);
            }
            return new Instance(Tree.randomId(), Markers.EMPTY, name, v);
        }

        public Executable executeVoid(Object ... args) {
            this.getValue().executeVoid(args);
            return this;
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitExecutable(this, p);
        }

        public Executable(UUID id, Markers markers, String name, Value value) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.Executable(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Executable)) {
                return false;
            }
            Executable other = (Executable)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Executable withId(UUID id) {
            return this.id == id ? this : new Executable(id, this.markers, this.name, this.value);
        }

        @NonNull
        public Executable withMarkers(Markers markers) {
            return this.markers == markers ? this : new Executable(this.id, markers, this.name, this.value);
        }

        @NonNull
        public Executable withName(String name) {
            return this.name == name ? this : new Executable(this.id, this.markers, name, this.value);
        }

        @Override
        @NonNull
        public Executable withValue(Value value) {
            return this.value == value ? this : new Executable(this.id, this.markers, this.name, value);
        }
    }

    public static final class Members
    implements Member {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final Value value;
        private final List<String> names;
        private final List<Member> members;

        public Members(UUID id, Markers markers, String name, Value value) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.names = value.getMemberKeys().stream().sorted().collect(Collectors.toList());
            this.members = this.names.stream().map(key -> {
                Value v = value.getMember(key);
                v.getMetaObject().putMember("member", key);
                if (v.canInstantiate()) {
                    return new Instantiable(Tree.randomId(), Markers.EMPTY, (String)key, v);
                }
                if (v.canExecute()) {
                    return new Executable(Tree.randomId(), Markers.EMPTY, (String)key, v);
                }
                if (v.hasMembers()) {
                    return new Members(Tree.randomId(), Markers.EMPTY, (String)key, v);
                }
                return new Instance(Tree.randomId(), Markers.EMPTY, (String)key, v);
            }).collect(Collectors.toList());
        }

        public Members(UUID id, Markers markers, String name, Value value, List<String> names, List<Member> members) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.names = names;
            this.members = members;
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitMembers(this, p);
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<Member> getMembers() {
            return this.members;
        }

        @NonNull
        public String toString() {
            return "Polyglot.Members(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", value=" + this.getValue() + ", names=" + this.getNames() + ", members=" + this.getMembers() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Members)) {
                return false;
            }
            Members other = (Members)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Members withId(UUID id) {
            return this.id == id ? this : new Members(id, this.markers, this.name, this.value, this.names, this.members);
        }

        @NonNull
        public Members withMarkers(Markers markers) {
            return this.markers == markers ? this : new Members(this.id, markers, this.name, this.value, this.names, this.members);
        }

        @NonNull
        public Members withName(String name) {
            return this.name == name ? this : new Members(this.id, this.markers, name, this.value, this.names, this.members);
        }

        @Override
        @NonNull
        public Members withValue(Value value) {
            return this.value == value ? this : new Members(this.id, this.markers, this.name, value, this.names, this.members);
        }

        @NonNull
        public Members withNames(List<String> names) {
            return this.names == names ? this : new Members(this.id, this.markers, this.name, this.value, names, this.members);
        }

        @NonNull
        public Members withMembers(List<Member> members) {
            return this.members == members ? this : new Members(this.id, this.markers, this.name, this.value, this.names, members);
        }
    }

    public static final class Source
    implements Polyglot,
    SourceFile {
        private final UUID id;
        private final Markers markers;
        private final Path sourcePath;
        private final Value value;
        private final Members members;

        public Source(UUID id, Markers markers, Path sourcePath, Value value) {
            this(id, markers, sourcePath, value, new Members(Tree.randomId(), Markers.EMPTY, sourcePath.toString(), value));
        }

        public Source(UUID id, Markers markers, Path sourcePath, Value value, Members members) {
            this.id = id;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.value = value;
            this.members = members;
        }

        @Override
        @Nullable
        public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitSource(this, p);
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        public Members getMembers() {
            return this.members;
        }

        @NonNull
        public String toString() {
            return "Polyglot.Source(id=" + this.getId() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", value=" + this.getValue() + ", members=" + this.getMembers() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            Source other = (Source)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Source withId(UUID id) {
            return this.id == id ? this : new Source(id, this.markers, this.sourcePath, this.value, this.members);
        }

        @NonNull
        public Source withMarkers(Markers markers) {
            return this.markers == markers ? this : new Source(this.id, markers, this.sourcePath, this.value, this.members);
        }

        @Override
        @NonNull
        public Source withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Source(this.id, this.markers, sourcePath, this.value, this.members);
        }

        @NonNull
        public Source withValue(Value value) {
            return this.value == value ? this : new Source(this.id, this.markers, this.sourcePath, value, this.members);
        }

        @NonNull
        public Source withMembers(Members members) {
            return this.members == members ? this : new Source(this.id, this.markers, this.sourcePath, this.value, members);
        }
    }

    public static final class ValueMarker
    implements Marker {
        private final UUID id;
        private final Value value;

        public ValueMarker(UUID id, Value value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Polyglot.ValueMarker(id=" + this.getId() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueMarker)) {
                return false;
            }
            ValueMarker other = (ValueMarker)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public ValueMarker withId(UUID id) {
            return this.id == id ? this : new ValueMarker(id, this.value);
        }

        @NonNull
        public ValueMarker withValue(Value value) {
            return this.value == value ? this : new ValueMarker(this.id, value);
        }
    }

    public static interface Member
    extends Polyglot {
        public Markers getMarkers();

        public <P extends Polyglot> P withMarkers(Markers var1);

        public String getName();

        public Member withValue(Value var1);

        default public boolean canInvoke() {
            return this.getValue().canInvokeMember(this.getName());
        }

        default public boolean canInstantiate() {
            return this.getValue().canInstantiate();
        }

        @Override
        @Nullable
        default public <P> Polyglot acceptPolyglot(PolyglotVisitor<P> pv, P p) {
            return pv.visitMember(this, p);
        }
    }
}

