/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Source;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeException;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.NpmRegistryModuleLoader;
import org.openrewrite.config.PolyglotResourceLoader;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.style.NamedStyles;

public class Environment {
    private final Collection<? extends ResourceLoader> resourceLoaders;

    public Collection<Recipe> listRecipes() {
        List<Recipe> recipes = this.resourceLoaders.stream().flatMap(r -> r.listRecipes().stream()).collect(Collectors.toList());
        for (Recipe recipe : recipes) {
            if (!(recipe instanceof DeclarativeRecipe)) continue;
            ((DeclarativeRecipe)recipe).initialize(recipes);
        }
        return recipes;
    }

    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.resourceLoaders.stream().flatMap(r -> r.listCategoryDescriptors().stream()).collect(Collectors.toList());
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.resourceLoaders.stream().flatMap(r -> r.listRecipeDescriptors().stream()).collect(Collectors.toList());
    }

    public Collection<RecipeExample> listRecipeExamples() {
        return this.resourceLoaders.stream().flatMap(r -> r.listRecipeExamples().stream()).collect(Collectors.toList());
    }

    public Recipe activateRecipes(Iterable<String> activeRecipes) {
        CompositeRecipe root = new CompositeRecipe();
        Collection<Recipe> recipes = this.listRecipes();
        ArrayList<String> recipesNotFound = new ArrayList<String>();
        for (String activeRecipe : activeRecipes) {
            boolean foundRecipe = false;
            for (Recipe recipe : recipes) {
                if (!activeRecipe.equals(recipe.getName())) continue;
                root.doNext(recipe);
                foundRecipe = true;
                break;
            }
            if (foundRecipe) continue;
            recipesNotFound.add(activeRecipe);
        }
        if (!recipesNotFound.isEmpty()) {
            throw new RecipeException("Recipes not found: " + String.join((CharSequence)", ", recipesNotFound));
        }
        return root;
    }

    public Recipe activateRecipes(String ... activeRecipes) {
        return this.activateRecipes(Arrays.asList(activeRecipes));
    }

    @Incubating(since="7.0.0")
    public Recipe activateAll() {
        CompositeRecipe root = new CompositeRecipe();
        this.listRecipes().forEach(root::doNext);
        return root;
    }

    public List<NamedStyles> listStyles() {
        return this.resourceLoaders.stream().flatMap(r -> r.listStyles().stream()).collect(Collectors.toList());
    }

    public List<NamedStyles> activateStyles(Iterable<String> activeStyles) {
        ArrayList<NamedStyles> activated = new ArrayList<NamedStyles>();
        List<NamedStyles> styles = this.listStyles();
        for (String activeStyle : activeStyles) {
            for (NamedStyles style : styles) {
                if (!style.getName().equals(activeStyle)) continue;
                activated.add(style);
            }
        }
        return activated;
    }

    public List<NamedStyles> activateStyles(String ... activeStyles) {
        return this.activateStyles(Arrays.asList(activeStyles));
    }

    public Environment(Collection<? extends ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    public static Builder builder(Properties properties) {
        return new Builder(properties);
    }

    public static Builder builder() {
        return new Builder(new Properties());
    }

    private static class CompositeRecipe
    extends Recipe {
        private CompositeRecipe() {
        }

        @Override
        public String getDisplayName() {
            return this.getName();
        }
    }

    public static class Builder {
        private final Properties properties;
        private final Collection<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();

        public Builder(Properties properties) {
            this.properties = properties;
        }

        public Builder scanRuntimeClasspath(String ... acceptPackages) {
            return this.load(new ClasspathScanningLoader(this.properties, acceptPackages));
        }

        public Builder scanJar(Path jar, ClassLoader classLoader) {
            return this.load(new ClasspathScanningLoader(jar, this.properties, classLoader));
        }

        public Builder scanNpmModules(String registry, String ... modules) {
            return this.load(new NpmRegistryModuleLoader(registry, modules));
        }

        public Builder scanPolyglotModule(Source ... sources) {
            return this.load(new PolyglotResourceLoader(sources));
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                Builder builder;
                FileInputStream is = new FileInputStream(userHomeRewriteConfig);
                try {
                    builder = this.load(new YamlResourceLoader(is, userHomeRewriteConfig.toURI(), this.properties));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
                return builder;
            }
            return this;
        }

        public Builder load(ResourceLoader resourceLoader) {
            this.resourceLoaders.add(resourceLoader);
            return this;
        }

        public Environment build() {
            return new Environment(this.resourceLoaders);
        }
    }
}

