/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public interface Tree {
    public static UUID randomId() {
        return UUID.randomUUID();
    }

    public UUID getId();

    @Nullable
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return v.defaultValue(this, p);
    }

    public <P> boolean isAcceptable(TreeVisitor<?, P> var1, P var2);

    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return cursor.firstEnclosingOrThrow(SourceFile.class).printer(cursor);
    }

    default public <P> String print(P p, Cursor cursor) {
        PrintOutputCapture<P> outputCapture = new PrintOutputCapture<P>(p);
        this.printer(cursor).visit(this, outputCapture, cursor);
        return outputCapture.out.toString();
    }

    default public String print(Cursor cursor) {
        return this.print(0, cursor);
    }

    default public <P> String printTrimmed(P p, Cursor cursor) {
        return StringUtils.trimIndent(this.print(p, cursor));
    }

    default public String printTrimmed(Cursor cursor) {
        return StringUtils.trimIndent(this.print(cursor));
    }

    default public boolean isScope(@Nullable Tree tree) {
        return tree != null && tree.getId().equals(this.getId());
    }
}

