/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;

@Incubating(since="7.12.0")
public final class CreateTextFile
extends Recipe {
    @Option(displayName="File Contents", description="Multiline text content for the file.", example="Some text.")
    private final String fileContents;
    @Option(displayName="Relative File Path", description="File path of new file.", example="foo/bar/baz.txt")
    private final String relativeFileName;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    @Nullable
    private final Boolean overwriteExisting;

    @Override
    public String getDisplayName() {
        return "Create text file";
    }

    @Override
    public String getDescription() {
        return "Creates a new plain text file.";
    }

    @Override
    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        Path path = Paths.get(this.relativeFileName, new String[0]);
        SourceFile matchingFile = null;
        for (SourceFile sourceFile : before) {
            if (!path.toString().equals(sourceFile.getSourcePath().toString())) continue;
            matchingFile = sourceFile;
        }
        if (matchingFile != null && !Boolean.TRUE.equals(this.overwriteExisting)) {
            return before;
        }
        PlainText brandNewFile = new PlainText(Tree.randomId(), path, Markers.EMPTY, this.fileContents);
        if (matchingFile != null && Boolean.TRUE.equals(this.overwriteExisting)) {
            brandNewFile = new PlainText(matchingFile.getId(), brandNewFile.getSourcePath(), brandNewFile.getMarkers(), brandNewFile.getText());
        }
        return ListUtils.concat(before, brandNewFile);
    }

    public CreateTextFile(String fileContents, String relativeFileName, @Nullable Boolean overwriteExisting) {
        this.fileContents = fileContents;
        this.relativeFileName = relativeFileName;
        this.overwriteExisting = overwriteExisting;
    }

    public String getFileContents() {
        return this.fileContents;
    }

    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Nullable
    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    public String toString() {
        return "CreateTextFile(fileContents=" + this.getFileContents() + ", relativeFileName=" + this.getRelativeFileName() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTextFile)) {
            return false;
        }
        CreateTextFile other = (CreateTextFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        return !(this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreateTextFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        return result;
    }
}

