/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.VersionComparator;

public final class ExactVersion
implements VersionComparator {
    private final String version;

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return this.version.equals(version);
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        return 0;
    }

    public static Validated build(String pattern) {
        int hyphenIndex = pattern.indexOf(45);
        String versionOnly = hyphenIndex == -1 ? pattern : pattern.substring(0, hyphenIndex);
        if (versionOnly.startsWith("latest") || versionOnly.contains("x") || versionOnly.contains("^") || versionOnly.contains("~") || versionOnly.contains(" ")) {
            return Validated.invalid("exactVersion", pattern, "not an exact version number");
        }
        return Validated.valid("exactVersion", new ExactVersion(pattern));
    }

    public ExactVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExactVersion)) {
            return false;
        }
        ExactVersion other = (ExactVersion)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ExactVersion(version=" + this.getVersion() + ")";
    }
}

