/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import org.graalvm.polyglot.Value;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.polyglot.Polyglot;

public class PolyglotVisitor<T>
extends TreeVisitor<Polyglot, T> {
    @Override
    @Nullable
    public Polyglot visit(@Nullable Tree tree, T ctx) {
        if (tree instanceof Polyglot.Instantiable) {
            return this.visitInstantiable((Polyglot.Instantiable)tree, ctx);
        }
        if (tree instanceof Polyglot.Executable) {
            return this.visitExecutable((Polyglot.Executable)tree, ctx);
        }
        if (tree instanceof Polyglot.Members) {
            return this.visitMembers((Polyglot.Members)tree, ctx);
        }
        if (tree instanceof Polyglot.HashEntries) {
            return this.visitHashEntries((Polyglot.HashEntries)tree, ctx);
        }
        if (tree instanceof Polyglot.ArrayElements) {
            return this.visitArrayElements((Polyglot.ArrayElements)tree, ctx);
        }
        if (tree instanceof Polyglot.StringValue) {
            return this.visitStringValue((Polyglot.StringValue)tree, ctx);
        }
        if (tree instanceof Polyglot.NumberValue) {
            return this.visitNumberValue((Polyglot.NumberValue)tree, ctx);
        }
        return (Polyglot)super.visit(tree, ctx);
    }

    public Polyglot visitSource(Polyglot.Source source, T ctx) {
        return source.withMembers((Polyglot.Members)this.visitAndCast(source.getMembers(), ctx)).withMarkers(this.visitMarkers(source.getMarkers(), ctx));
    }

    public Polyglot visitMembers(Polyglot.Members members, T ctx) {
        return members.withMembers(ListUtils.map(members.getMembers(), m -> (Polyglot.Member)this.visitAndCast((Tree)m, ctx))).withMarkers(this.visitMarkers(members.getMarkers(), ctx));
    }

    public Polyglot visitMember(Polyglot.Member member, T ctx) {
        return member.withMarkers(this.visitMarkers(member.getMarkers(), ctx));
    }

    public Polyglot visitStringValue(Polyglot.StringValue stringValue, T ctx) {
        return stringValue.withMarkers(this.visitMarkers(stringValue.getMarkers(), ctx));
    }

    public Polyglot visitNumberValue(Polyglot.NumberValue numberValue, T ctx) {
        return numberValue.withMarkers(this.visitMarkers(numberValue.getMarkers(), ctx));
    }

    public Polyglot visitInstantiable(Polyglot.Instantiable instantiable, T ctx) {
        return instantiable.withValue((Value)this.visitAndCast(instantiable, ctx)).withMarkers(this.visitMarkers(instantiable.getMarkers(), ctx));
    }

    public Polyglot visitHashEntries(Polyglot.HashEntries hashEntries, T ctx) {
        return hashEntries.withEntries(ListUtils.map(hashEntries.getEntries(), m -> (Polyglot.HashEntry)this.visitAndCast((Tree)m, ctx))).withMarkers(this.visitMarkers(hashEntries.getMarkers(), ctx));
    }

    public Polyglot visitHashEntry(Polyglot.HashEntry hashEntry, T ctx) {
        return hashEntry.withMarkers(this.visitMarkers(hashEntry.getMarkers(), ctx));
    }

    public Polyglot visitArrayElements(Polyglot.ArrayElements arrayElements, T ctx) {
        return arrayElements.withElements(ListUtils.map(arrayElements.getElements(), e -> (Polyglot.ArrayElement)this.visitAndCast((Tree)e, ctx))).withMarkers(this.visitMarkers(arrayElements.getMarkers(), ctx));
    }

    public Polyglot visitArrayElement(Polyglot.ArrayElement arrayElement, T ctx) {
        return arrayElement.withMarkers(this.visitMarkers(arrayElement.getMarkers(), ctx));
    }

    public Polyglot visitExecutable(Polyglot.Executable executable, T ctx) {
        return executable.withMarkers(this.visitMarkers(executable.getMarkers(), ctx));
    }

    public Polyglot visitError(Polyglot.Error error, T ctx) {
        return error.withMarkers(this.visitMarkers(error.getMarkers(), ctx));
    }

    public Polyglot visitInstance(Polyglot.Instance instance, T ctx) {
        return instance.withMarkers(this.visitMarkers(instance.getMarkers(), ctx));
    }
}

