/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Source;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.polyglot.Polyglot;
import org.openrewrite.polyglot.PolyglotParser;
import org.openrewrite.polyglot.PolyglotRecipe;
import org.openrewrite.polyglot.PolyglotValueMappings;
import org.openrewrite.polyglot.PolyglotVisitor;
import org.openrewrite.style.NamedStyles;

public class PolyglotResourceLoader
implements ResourceLoader {
    private final List<PolyglotRecipes> recipes = new ArrayList<PolyglotRecipes>();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final List<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();
    private final List<CategoryDescriptor> categoryDescriptors = new ArrayList<CategoryDescriptor>();
    private final List<RecipeExample> recipeExamples = new ArrayList<RecipeExample>();

    public PolyglotResourceLoader(Source ... sources) {
        for (Source src : sources) {
            try {
                this.evalPolyglotRecipe(src);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes.stream().flatMap(rs -> rs.getRecipes().stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.recipeDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.categoryDescriptors;
    }

    @Override
    public Collection<RecipeExample> listRecipeExamples() {
        return this.recipeExamples;
    }

    public void evalPolyglotRecipe(Source moduleSrc) throws IOException {
        this.recipes.add(new PolyglotRecipes(moduleSrc));
        this.recipes.stream().flatMap(r -> r.getRecipes().stream()).forEach(r -> {
            this.recipeDescriptors.add(r.getRecipeDescriptor());
            this.categoryDescriptors.addAll(r.getCategoryDescriptors());
            this.styles.addAll(r.getNamedStyles());
        });
    }

    private static final class PolyglotRecipes {
        private final PolyglotParser parser = new PolyglotParser();
        private final Source source;
        private final ThreadLocal<List<PolyglotRecipe>> perThreadRecipes = new InheritableThreadLocal<List<PolyglotRecipe>>(){

            @Override
            protected List<PolyglotRecipe> initialValue() {
                List<Polyglot.Source> sources = parser.parse((ExecutionContext)new InMemoryExecutionContext(), source);
                ArrayList<PolyglotRecipe> recipes = new ArrayList<PolyglotRecipe>();
                PolyglotVisitor<List<PolyglotRecipe>> recipesVisitor = new PolyglotVisitor<List<PolyglotRecipe>>(){

                    @Override
                    public Polyglot visitInstantiable(Polyglot.Instantiable instantiable, List<PolyglotRecipe> l) {
                        Polyglot.Instance inst = instantiable.instantiate(new Object[0]);
                        if (PolyglotValueMappings.hasGetVisitor().test(inst.getValue())) {
                            inst.as(PolyglotRecipe.class).ifPresent(l::add);
                            return inst;
                        }
                        return instantiable;
                    }
                };
                for (Polyglot.Source src : sources) {
                    recipesVisitor.visitMembers(src.getMembers(), recipes);
                }
                return recipes;
            }
        };

        public List<PolyglotRecipe> getRecipes() {
            return this.perThreadRecipes.get();
        }

        public PolyglotParser getParser() {
            return this.parser;
        }

        public Source getSource() {
            return this.source;
        }

        public ThreadLocal<List<PolyglotRecipe>> getPerThreadRecipes() {
            return this.perThreadRecipes;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PolyglotRecipes)) {
                return false;
            }
            PolyglotRecipes other = (PolyglotRecipes)o;
            PolyglotParser this$parser = this.getParser();
            PolyglotParser other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            Source this$source = this.getSource();
            Source other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            ThreadLocal<List<PolyglotRecipe>> this$perThreadRecipes = this.getPerThreadRecipes();
            ThreadLocal<List<PolyglotRecipe>> other$perThreadRecipes = other.getPerThreadRecipes();
            return !(this$perThreadRecipes == null ? other$perThreadRecipes != null : !this$perThreadRecipes.equals(other$perThreadRecipes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PolyglotParser $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            Source $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            ThreadLocal<List<PolyglotRecipe>> $perThreadRecipes = this.getPerThreadRecipes();
            result = result * 59 + ($perThreadRecipes == null ? 43 : $perThreadRecipes.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "PolyglotResourceLoader.PolyglotRecipes(parser=" + this.getParser() + ", source=" + this.getSource() + ", perThreadRecipes=" + this.getPerThreadRecipes() + ")";
        }

        public PolyglotRecipes(Source source) {
            this.source = source;
        }
    }
}

