/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.scheduling.WatchableExecutionContext;

public interface RecipeScheduler {
    default public <T> List<T> mapAsync(List<T> input, UnaryOperator<T> mapFn) {
        CompletableFuture[] futures = new CompletableFuture[input.size()];
        int i = 0;
        for (Object before : input) {
            Callable<Object> updateTreeFn = () -> mapFn.apply(before);
            futures[i++] = this.schedule(updateTreeFn);
        }
        CompletableFuture.allOf(futures).join();
        return ListUtils.map(input, (j, in) -> futures[j].join());
    }

    default public List<Result> scheduleRun(Recipe recipe, List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles, int minCycles) {
        List<? extends SourceFile> acc;
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", recipe.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Stack<Recipe>> recipeThatDeletedSourceFile = new HashMap<UUID, Stack<Recipe>>();
        List<? extends SourceFile> after = acc = before;
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        for (int i = 0; i < maxCycles; ++i) {
            Stack<Recipe> recipeStack = new Stack<Recipe>();
            recipeStack.push(recipe);
            after = this.scheduleVisit(recipeStack, acc, ctxWithWatch, recipeThatDeletedSourceFile);
            if (i + 1 >= minCycles && (after == acc && !ctxWithWatch.hasNewMessages() || !recipe.causesAnotherCycle())) break;
            acc = after;
            ctxWithWatch.resetHasNewMessages();
        }
        if (after == before) {
            return Collections.emptyList();
        }
        Map sourceFileIdentities = before.stream().collect(Collectors.toMap(Tree::getId, Function.identity()));
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile : after) {
            boolean isChanged;
            SourceFile sourceFile2 = (SourceFile)sourceFileIdentities.get(sourceFile.getId());
            if (sourceFile2 == sourceFile) continue;
            if (sourceFile2 == null) {
                results.add(new Result(null, sourceFile, Collections.singleton((Stack)recipeThatDeletedSourceFile.get(sourceFile.getId()))));
                continue;
            }
            if (sourceFile2.getMarkers().findFirst(Generated.class).isPresent()) continue;
            boolean bl = isChanged = !sourceFile2.getSourcePath().equals(sourceFile.getSourcePath());
            if (!isChanged) {
                TreeVisitor<Tree, PrintOutputCapture<ExecutionContext>> markerIdPrinter = new TreeVisitor<Tree, PrintOutputCapture<ExecutionContext>>(){

                    @Override
                    public Tree visit(@Nullable Tree tree, PrintOutputCapture<ExecutionContext> p) {
                        String markerIds;
                        if (tree instanceof Markers && !(markerIds = ((Markers)tree).entries().stream().filter(marker -> !(marker instanceof RecipesThatMadeChanges)).map(marker -> String.valueOf(marker.hashCode())).collect(Collectors.joining(","))).isEmpty()) {
                            p.out.append("markers[").append(markerIds).append("]->");
                        }
                        return super.visit(tree, p);
                    }
                };
                PrintOutputCapture<ExecutionContext> originalOutput = new PrintOutputCapture<ExecutionContext>(ctx);
                PrintOutputCapture<ExecutionContext> sOutput = new PrintOutputCapture<ExecutionContext>(ctx);
                markerIdPrinter.visit(sourceFile2, originalOutput);
                markerIdPrinter.visit(sourceFile, sOutput);
                boolean bl2 = isChanged = !originalOutput.toString().equals(sOutput.toString());
            }
            if (!isChanged) continue;
            results.add(new Result(sourceFile2, sourceFile, sourceFile.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change?")).getRecipes()));
        }
        Set afterIds = after.stream().map(Tree::getId).collect(Collectors.toSet());
        for (SourceFile sourceFile : before) {
            if (afterIds.contains(sourceFile.getId()) || sourceFile.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile, null, Collections.singleton((Stack)recipeThatDeletedSourceFile.get(sourceFile.getId()))));
        }
        return results;
    }

    default public <S extends SourceFile> List<S> scheduleVisit(Stack<Recipe> recipeStack, List<S> before, ExecutionContext ctx, Map<UUID, Stack<Recipe>> recipeThatDeletedSourceFile) {
        List<SourceFile> after;
        List<SourceFile> afterWidened;
        long startTime = System.nanoTime();
        AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean(false);
        Recipe recipe = recipeStack.peek();
        if (recipe.getApplicableTest() != null) {
            boolean applicable = false;
            for (SourceFile s2 : before) {
                if (recipe.getApplicableTest().visit(s2, ctx) == s2) continue;
                applicable = true;
                break;
            }
            if (!applicable) {
                return before;
            }
        }
        if ((afterWidened = recipe.visit(after = !recipe.validate(ctx).isValid() ? before : this.mapAsync(before, s -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", recipe.getDisplayName());
            Timer.Sample sample = Timer.start();
            if (recipe.getSingleSourceApplicableTest() != null && recipe.getSingleSourceApplicableTest().visit((Tree)s, ctx) == s) {
                sample.stop(MetricsHelper.successTags(timer, s, "skipped").register((MeterRegistry)Metrics.globalRegistry));
                return s;
            }
            Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
            if (duration.compareTo(ctx.getRunTimeout(before.size())) > 0) {
                if (thrownErrorOnTimeout.compareAndSet(false, true)) {
                    RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                    ctx.getOnError().accept(t);
                    ctx.getOnTimeout().accept(t, ctx);
                }
                sample.stop(MetricsHelper.successTags(timer, s, "timeout").register((MeterRegistry)Metrics.globalRegistry));
                return s;
            }
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return s;
            }
            try {
                SourceFile afterFile = (SourceFile)recipe.getVisitor().visit((Tree)s, ctx);
                if (afterFile != null && afterFile != s) {
                    ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
                    recipeStackList.add(recipeStack);
                    afterFile = afterFile.withMarkers(afterFile.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
                        r1.getRecipes().addAll(r2.getRecipes());
                        return r1;
                    }));
                    sample.stop(MetricsHelper.successTags(timer, s, "changed").register((MeterRegistry)Metrics.globalRegistry));
                } else if (afterFile == null) {
                    recipeThatDeletedSourceFile.put(s.getId(), recipeStack);
                    sample.stop(MetricsHelper.successTags(timer, s, "deleted").register((MeterRegistry)Metrics.globalRegistry));
                } else {
                    sample.stop(MetricsHelper.successTags(timer, s, "unchanged").register((MeterRegistry)Metrics.globalRegistry));
                }
                return afterFile;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags(timer, s, t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
                return s;
            }
        }), ctx)) != after) {
            HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
            for (SourceFile file : after) {
                originalMap.put(file.getId(), file);
            }
            afterWidened = ListUtils.map(afterWidened, s -> {
                SourceFile original = (SourceFile)originalMap.get(s.getId());
                if (original == null) {
                    recipeThatDeletedSourceFile.put(s.getId(), recipeStack);
                } else if (s != original) {
                    ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
                    recipeStackList.add(recipeStack);
                    return s.withMarkers(s.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
                        r1.getRecipes().addAll(r2.getRecipes());
                        return r1;
                    }));
                }
                return s;
            });
            for (SourceFile maybeDeleted : after) {
                if (afterWidened.contains(maybeDeleted)) continue;
                recipeThatDeletedSourceFile.put(maybeDeleted.getId(), recipeStack);
            }
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return afterWidened;
            }
            Stack<Recipe> nextStack = new Stack<Recipe>();
            nextStack.addAll(recipeStack);
            nextStack.push(r);
            afterWidened = this.scheduleVisit(nextStack, afterWidened, ctx, recipeThatDeletedSourceFile);
        }
        return afterWidened;
    }

    public <T> CompletableFuture<T> schedule(Callable<T> var1);
}

