/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class DeleteSourceFiles
extends Recipe {
    @Option(displayName="File pattern", description="A glob expression representing a file path to delete (relative to the project root).", example=".github/workflows/*.yml")
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Delete files";
    }

    @Override
    public String getDescription() {
        return "Delete files by source path.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                SourceFile sourceFile;
                Path sourcePath;
                PathMatcher pathMatcher;
                if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher("glob:" + DeleteSourceFiles.this.filePattern)).matches(sourcePath)) {
                    return null;
                }
                return tree;
            }
        };
    }

    public DeleteSourceFiles(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "DeleteSourceFiles(filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSourceFiles)) {
            return false;
        }
        DeleteSourceFiles other = (DeleteSourceFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteSourceFiles;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

