/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.revwalk.filter;

import java.io.IOException;
import org.openrewrite.shaded.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.shaded.jgit.errors.MissingObjectException;
import org.openrewrite.shaded.jgit.errors.StopWalkException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;
import org.openrewrite.shaded.jgit.revwalk.filter.RevFilter;

public class MaxCountRevFilter
extends RevFilter {
    private int maxCount;
    private int count = 0;

    public static RevFilter create(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException(JGitText.get().maxCountMustBeNonNegative);
        }
        return new MaxCountRevFilter(maxCount);
    }

    private MaxCountRevFilter(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        ++this.count;
        if (this.count > this.maxCount) {
            throw StopWalkException.INSTANCE;
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new MaxCountRevFilter(this.maxCount);
    }
}

