/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.errors;

import java.text.MessageFormat;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.AnyObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectId;

public class LargeObjectException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ObjectId objectId;

    public LargeObjectException() {
    }

    public LargeObjectException(Throwable cause) {
        this.initCause(cause);
    }

    public LargeObjectException(AnyObjectId id) {
        this.setObjectId(id);
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    protected String getObjectName() {
        if (this.getObjectId() != null) {
            return this.getObjectId().name();
        }
        return JGitText.get().unknownObject;
    }

    public void setObjectId(AnyObjectId id) {
        if (this.objectId == null) {
            this.objectId = id.copy();
        }
    }

    @Override
    public String getMessage() {
        return MessageFormat.format(JGitText.get().largeObjectException, this.getObjectName());
    }

    public static class ExceedsByteArrayLimit
    extends LargeObjectException {
        private static final long serialVersionUID = 1L;

        @Override
        public String getMessage() {
            return MessageFormat.format(JGitText.get().largeObjectExceedsByteArray, this.getObjectName());
        }
    }

    public static class ExceedsLimit
    extends LargeObjectException {
        private static final long serialVersionUID = 1L;
        private final long limit;
        private final long size;

        public ExceedsLimit(long limit, long size) {
            this.limit = limit;
            this.size = size;
        }

        @Override
        public String getMessage() {
            return MessageFormat.format(JGitText.get().largeObjectExceedsLimit, this.getObjectName(), this.limit, this.size);
        }
    }

    public static class OutOfMemory
    extends LargeObjectException {
        private static final long serialVersionUID = 1L;

        public OutOfMemory(OutOfMemoryError cause) {
            this.initCause(cause);
        }

        @Override
        public String getMessage() {
            return MessageFormat.format(JGitText.get().largeObjectOutOfMemory, this.getObjectName());
        }
    }
}

