/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.UUID;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class BuildTool
implements Marker {
    private final UUID id;
    private final Type type;
    private final String version;

    public BuildTool(UUID id, Type type, String version) {
        this.id = id;
        this.type = type;
        this.version = version;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "BuildTool(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildTool)) {
            return false;
        }
        BuildTool other = (BuildTool)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public BuildTool withId(UUID id) {
        return this.id == id ? this : new BuildTool(id, this.type, this.version);
    }

    @NonNull
    public BuildTool withType(Type type) {
        return this.type == type ? this : new BuildTool(this.id, type, this.version);
    }

    @NonNull
    public BuildTool withVersion(String version) {
        return this.version == version ? this : new BuildTool(this.id, this.type, version);
    }

    public static enum Type {
        Gradle,
        Maven;

    }
}

