/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.openrewrite.Recipe;

public class RecipeSerializer {
    private final ObjectMapper mapper;

    public RecipeSerializer() {
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)f).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new KotlinModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public void write(Recipe recipe, OutputStream out) {
        try {
            this.mapper.writeValue(out, (Object)recipe);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] write(Recipe recipe) {
        try {
            return this.mapper.writeValueAsBytes((Object)recipe);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public Recipe read(InputStream input) {
        try {
            return (Recipe)this.mapper.readValue(input, Recipe.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Recipe read(byte[] bytes) {
        try {
            return (Recipe)this.mapper.readValue(bytes, Recipe.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

