/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import org.openrewrite.Validated;
import org.openrewrite.semver.VersionComparator;

public class ExactVersion
implements VersionComparator {
    private final String version;

    public ExactVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isValid(String version) {
        return this.version.equals(version);
    }

    @Override
    public int compare(String o1, String o2) {
        return 0;
    }

    public static Validated build(String pattern) {
        int hyphenIndex = pattern.indexOf(45);
        String versionOnly = hyphenIndex == -1 ? pattern : pattern.substring(0, hyphenIndex);
        if (versionOnly.startsWith("latest") || versionOnly.contains("x") || versionOnly.contains("^") || versionOnly.contains("~") || versionOnly.contains(" ")) {
            return Validated.invalid("exactVersion", pattern, "not an exact version number");
        }
        return Validated.valid("exactVersion", new ExactVersion(pattern));
    }
}

