/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.UUID;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

@Incubating(since="7.0.0")
public class RecipeSearchResult
implements SearchResult {
    private final UUID id;
    private final Recipe recipe;
    @Nullable
    private final String description;

    public RecipeSearchResult(UUID id, Recipe recipe) {
        this(id, recipe, null);
    }

    @Override
    public <P> String print(TreePrinter<P> printer, P p) {
        if (this.getDescription() == null) {
            return "~~>";
        }
        return String.format("~~(%s)~~>", this.getDescription());
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String toString() {
        return "RecipeSearchResult(id=" + this.getId() + ", recipe=" + this.getRecipe() + ", description=" + this.getDescription() + ")";
    }

    public RecipeSearchResult(UUID id, Recipe recipe, @Nullable String description) {
        this.id = id;
        this.recipe = recipe;
        this.description = description;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeSearchResult)) {
            return false;
        }
        RecipeSearchResult other = (RecipeSearchResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Recipe this$recipe = this.getRecipe();
        Recipe other$recipe = other.getRecipe();
        if (this$recipe == null ? other$recipe != null : !((Object)this$recipe).equals(other$recipe)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RecipeSearchResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Recipe $recipe = this.getRecipe();
        result = result * 59 + ($recipe == null ? 43 : ((Object)$recipe).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

