/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.VersionComparator;

public class LatestRelease
implements VersionComparator {
    @Nullable
    private final String metadataPattern;

    public LatestRelease(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    @Override
    public boolean isValid(String version) {
        Matcher matcher = VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(version));
        if (!matcher.matches() || PRE_RELEASE_ENDING.matcher(version).find()) {
            return false;
        }
        return this.metadataPattern == null || matcher.group(4) != null && matcher.group(4).matches(this.metadataPattern);
    }

    static String normalizeVersion(String version) {
        if (version.endsWith(".RELEASE")) {
            return version.substring(0, version.length() - ".RELEASE".length());
        }
        if (version.endsWith(".FINAL") || version.endsWith(".Final")) {
            return version.substring(0, version.length() - ".FINAL".length());
        }
        AtomicBoolean beforeMetadata = new AtomicBoolean(true);
        long versionParts = version.chars().filter(c -> {
            if (c == 45 || c == 43) {
                beforeMetadata.set(false);
            }
            return beforeMetadata.get();
        }).filter(c -> c == 46).count();
        if (versionParts < 2L) {
            String[] versionAndMetadata = version.split("(?=[-+])");
            while (versionParts < 2L) {
                versionAndMetadata[0] = versionAndMetadata[0] + ".0";
                ++versionParts;
            }
            version = versionAndMetadata[0] + (versionAndMetadata.length > 1 ? versionAndMetadata[1] : "");
        }
        return version;
    }

    @Override
    public int compare(String v1, String v2) {
        Matcher v1Gav = VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(v1));
        Matcher v2Gav = VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(v2));
        v1Gav.matches();
        v2Gav.matches();
        for (int i = 1; i <= 3; ++i) {
            String v1Part = v1Gav.group(i);
            String v2Part = v2Gav.group(i);
            if (v1Part == null) {
                return v2Part == null ? 0 : -11;
            }
            if (v2Part == null) {
                return 1;
            }
            int diff = Integer.parseInt(v1Part) - Integer.parseInt(v2Part);
            if (diff == 0) continue;
            return diff;
        }
        return v1.compareTo(v2);
    }

    public static Validated build(String toVersion, @Nullable String metadataPattern) {
        return toVersion.equals("latest.release") ? Validated.valid("latestRelease", new LatestRelease(metadataPattern)) : Validated.invalid("latestRelease", toVersion, "not a hyphen range");
    }
}

