/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.RecipeSearchResult;

public class HasSourcePath<P>
extends TreeVisitor<Tree, P> {
    private final String syntax;
    private final String filePattern;

    public HasSourcePath(String filePattern) {
        this("glob", filePattern);
    }

    public HasSourcePath(String syntax, String filePattern) {
        this.syntax = syntax;
        this.filePattern = filePattern;
    }

    @Override
    @Nullable
    public Tree visit(@Nullable Tree tree, P p) {
        Path sourcePath;
        PathMatcher pathMatcher;
        if (tree instanceof SourceFile && (pathMatcher = (sourcePath = ((SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher(this.syntax + ":" + this.filePattern)).matches(sourcePath)) {
            return new RecipeSearchResult(Tree.randomId(), null, "has file");
        }
        return super.visit(tree, p);
    }
}

