/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLHandshakeException;
import org.openrewrite.shaded.jgit.annotations.NonNull;
import org.openrewrite.shaded.jgit.errors.ConfigInvalidException;
import org.openrewrite.shaded.jgit.errors.NoRemoteRepositoryException;
import org.openrewrite.shaded.jgit.errors.NotSupportedException;
import org.openrewrite.shaded.jgit.errors.PackProtocolException;
import org.openrewrite.shaded.jgit.errors.TransportException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.internal.transport.http.NetscapeCookieFile;
import org.openrewrite.shaded.jgit.internal.transport.http.NetscapeCookieFileCache;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectIdRef;
import org.openrewrite.shaded.jgit.lib.ProgressMonitor;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.lib.StoredConfig;
import org.openrewrite.shaded.jgit.lib.SymbolicRef;
import org.openrewrite.shaded.jgit.transport.BaseConnection;
import org.openrewrite.shaded.jgit.transport.BasePackFetchConnection;
import org.openrewrite.shaded.jgit.transport.BasePackPushConnection;
import org.openrewrite.shaded.jgit.transport.CredentialItem;
import org.openrewrite.shaded.jgit.transport.CredentialsProvider;
import org.openrewrite.shaded.jgit.transport.FetchConnection;
import org.openrewrite.shaded.jgit.transport.HttpAuthMethod;
import org.openrewrite.shaded.jgit.transport.HttpConfig;
import org.openrewrite.shaded.jgit.transport.HttpTransport;
import org.openrewrite.shaded.jgit.transport.PackTransport;
import org.openrewrite.shaded.jgit.transport.PacketLineIn;
import org.openrewrite.shaded.jgit.transport.PushConnection;
import org.openrewrite.shaded.jgit.transport.RefSpec;
import org.openrewrite.shaded.jgit.transport.RemoteRefUpdate;
import org.openrewrite.shaded.jgit.transport.TransferConfig;
import org.openrewrite.shaded.jgit.transport.Transport;
import org.openrewrite.shaded.jgit.transport.TransportProtocol;
import org.openrewrite.shaded.jgit.transport.URIish;
import org.openrewrite.shaded.jgit.transport.UserAgent;
import org.openrewrite.shaded.jgit.transport.WalkFetchConnection;
import org.openrewrite.shaded.jgit.transport.WalkRemoteObjectDatabase;
import org.openrewrite.shaded.jgit.transport.WalkTransport;
import org.openrewrite.shaded.jgit.transport.http.HttpConnection;
import org.openrewrite.shaded.jgit.transport.http.HttpConnectionFactory;
import org.openrewrite.shaded.jgit.transport.http.HttpConnectionFactory2;
import org.openrewrite.shaded.jgit.util.HttpSupport;
import org.openrewrite.shaded.jgit.util.IO;
import org.openrewrite.shaded.jgit.util.RawParseUtils;
import org.openrewrite.shaded.jgit.util.StringUtils;
import org.openrewrite.shaded.jgit.util.SystemReader;
import org.openrewrite.shaded.jgit.util.TemporaryBuffer;
import org.openrewrite.shaded.jgit.util.io.DisabledOutputStream;
import org.openrewrite.shaded.jgit.util.io.UnionInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportHttp
extends HttpTransport
implements WalkTransport,
PackTransport {
    private static final Logger LOG = LoggerFactory.getLogger(TransportHttp.class);
    private static final String SVC_UPLOAD_PACK = "git-upload-pack";
    private static final String SVC_RECEIVE_PACK = "git-receive-pack";
    private static final byte[] VERSION = "version".getBytes(StandardCharsets.US_ASCII);
    static final TransportProtocol PROTO_HTTP = new TransportProtocol(){
        private final String[] schemeNames = new String[]{"http", "https"};
        private final Set<String> schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

        @Override
        public String getName() {
            return JGitText.get().transportProtoHTTP;
        }

        @Override
        public Set<String> getSchemes() {
            return this.schemeSet;
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 80;
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportHttp(local, uri);
        }

        @Override
        public Transport open(URIish uri) throws NotSupportedException {
            return new TransportHttp(uri);
        }
    };
    static final TransportProtocol PROTO_FTP = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoFTP;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("ftp");
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 21;
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportHttp(local, uri);
        }
    };
    private URIish currentUri;
    private URL baseUrl;
    private URL objectsUrl;
    private final HttpConfig http;
    private final ProxySelector proxySelector;
    private boolean useSmartHttp = true;
    private HttpAuthMethod authMethod = HttpAuthMethod.Type.NONE.method(null);
    private Map<String, String> headers;
    private boolean sslVerify;
    private boolean sslFailure = false;
    private HttpConnectionFactory factory;
    private HttpConnectionFactory2.GitSession gitSession;
    private boolean factoryUsed;
    private final NetscapeCookieFile cookieFile;
    private final Set<HttpCookie> relevantCookies;

    TransportHttp(Repository local, URIish uri) throws NotSupportedException {
        super(local, uri);
        this.setURI(uri);
        this.http = new HttpConfig(local.getConfig(), uri);
        this.proxySelector = ProxySelector.getDefault();
        this.sslVerify = this.http.isSslVerify();
        this.cookieFile = TransportHttp.getCookieFileFromConfig(this.http);
        this.relevantCookies = TransportHttp.filterCookies(this.cookieFile, this.baseUrl);
        this.factory = HttpTransport.getConnectionFactory();
    }

    private URL toURL(URIish urish) throws MalformedURLException {
        String uriString = urish.toString();
        if (!uriString.endsWith("/")) {
            uriString = String.valueOf(uriString) + '/';
        }
        return new URL(uriString);
    }

    protected void setURI(URIish uri) throws NotSupportedException {
        try {
            this.currentUri = uri;
            this.baseUrl = this.toURL(uri);
            this.objectsUrl = new URL(this.baseUrl, "objects/");
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, uri), e);
        }
    }

    TransportHttp(URIish uri) throws NotSupportedException {
        super(uri);
        this.setURI(uri);
        this.http = new HttpConfig(uri);
        this.proxySelector = ProxySelector.getDefault();
        this.sslVerify = this.http.isSslVerify();
        this.cookieFile = TransportHttp.getCookieFileFromConfig(this.http);
        this.relevantCookies = TransportHttp.filterCookies(this.cookieFile, this.baseUrl);
        this.factory = HttpTransport.getConnectionFactory();
    }

    public void setUseSmartHttp(boolean on) {
        this.useSmartHttp = on;
    }

    private FetchConnection getConnection(HttpConnection c, InputStream in, String service, Collection<RefSpec> refSpecs, String ... additionalPatterns) throws IOException {
        BaseConnection f;
        if (this.isSmartHttp(c, service)) {
            InputStream withMark = in.markSupported() ? in : new BufferedInputStream(in);
            this.readSmartHeaders(withMark, service);
            f = new SmartHttpFetchConnection(withMark, refSpecs, additionalPatterns);
        } else {
            f = this.newDumbConnection(in);
        }
        f.setPeerUserAgent(c.getHeaderField("Server"));
        return f;
    }

    public void setHttpConnectionFactory(@NonNull HttpConnectionFactory customFactory) {
        if (this.factoryUsed) {
            throw new IllegalStateException(JGitText.get().httpFactoryInUse);
        }
        this.factory = customFactory;
    }

    @NonNull
    public HttpConnectionFactory getHttpConnectionFactory() {
        return this.factory;
    }

    public void setPreemptiveBasicAuthentication(String username, String password) {
        if (this.factoryUsed) {
            throw new IllegalStateException(JGitText.get().httpPreAuthTooLate);
        }
        if (StringUtils.isEmptyOrNull(username) || StringUtils.isEmptyOrNull(password)) {
            this.authMethod = this.authFromUri(this.currentUri);
        } else {
            HttpAuthMethod basic = HttpAuthMethod.Type.BASIC.method(null);
            basic.authorize(username, password);
            this.authMethod = basic;
        }
    }

    @Override
    public FetchConnection openFetch() throws TransportException, NotSupportedException {
        return this.openFetch(Collections.emptyList(), new String[0]);
    }

    @Override
    public FetchConnection openFetch(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws NotSupportedException, TransportException {
        String service = SVC_UPLOAD_PACK;
        try {
            TransferConfig.ProtocolVersion gitProtocol = this.protocol;
            if (gitProtocol == null) {
                gitProtocol = TransferConfig.ProtocolVersion.V2;
            }
            HttpConnection c = this.connect(SVC_UPLOAD_PACK, gitProtocol);
            Throwable throwable = null;
            Object var7_10 = null;
            try (InputStream in = this.openInputStream(c);){
                return this.getConnection(c, in, SVC_UPLOAD_PACK, refSpecs, additionalPatterns);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NotSupportedException | TransportException err) {
            throw err;
        }
        catch (IOException err) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, err);
        }
    }

    private WalkFetchConnection newDumbConnection(InputStream in) throws IOException, PackProtocolException {
        Map<String, Ref> refs;
        HttpObjectDB d = new HttpObjectDB(this.objectsUrl);
        Throwable throwable = null;
        Object var5_5 = null;
        try (BufferedReader br = this.toBufferedReader(in);){
            refs = d.readAdvertisedImpl(br);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!refs.containsKey("HEAD")) {
            HttpConnection conn = this.httpOpen("GET", new URL(this.baseUrl, "HEAD"), AcceptEncoding.GZIP);
            int status = HttpSupport.response(conn);
            switch (status) {
                case 200: {
                    Throwable throwable3 = null;
                    Object var7_11 = null;
                    try (BufferedReader br = this.toBufferedReader(this.openInputStream(conn));){
                        String line = br.readLine();
                        if (line != null && line.startsWith("ref: ")) {
                            String target = line.substring("ref: ".length());
                            Ref r = refs.get(target);
                            if (r == null) {
                                r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                            }
                            r = new SymbolicRef("HEAD", r);
                            refs.put(r.getName(), r);
                        } else if (line != null && ObjectId.isId(line)) {
                            ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, "HEAD", ObjectId.fromString(line));
                            refs.put(r.getName(), r);
                        }
                        break;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                case 404: {
                    break;
                }
                default: {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotReadHEAD, status, conn.getResponseMessage()));
                }
            }
        }
        WalkFetchConnection wfc = new WalkFetchConnection(this, d);
        wfc.available(refs);
        return wfc;
    }

    private BufferedReader toBufferedReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    public PushConnection openPush() throws NotSupportedException, TransportException {
        String service = SVC_RECEIVE_PACK;
        try {
            HttpConnection c = this.connect(SVC_RECEIVE_PACK);
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream in = this.openInputStream(c);){
                if (this.isSmartHttp(c, SVC_RECEIVE_PACK)) {
                    return this.smartPush(SVC_RECEIVE_PACK, c, in);
                }
                if (!this.useSmartHttp) {
                    String msg = JGitText.get().smartHTTPPushDisabled;
                    throw new NotSupportedException(msg);
                }
                String msg = JGitText.get().remoteDoesNotSupportSmartHTTPPush;
                throw new NotSupportedException(msg);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NotSupportedException | TransportException err) {
            throw err;
        }
        catch (IOException err) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, err);
        }
    }

    private PushConnection smartPush(String service, HttpConnection c, InputStream in) throws IOException, TransportException {
        BufferedInputStream inBuf = new BufferedInputStream(in);
        this.readSmartHeaders(inBuf, service);
        SmartHttpPushConnection p = new SmartHttpPushConnection(inBuf);
        p.setPeerUserAgent(c.getHeaderField("Server"));
        return p;
    }

    @Override
    public void close() {
        if (this.gitSession != null) {
            this.gitSession.close();
            this.gitSession = null;
        }
    }

    public void setAdditionalHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    private NoRemoteRepositoryException createNotFoundException(URIish u, URL url, String msg) {
        String text = msg != null && !msg.isEmpty() ? MessageFormat.format(JGitText.get().uriNotFoundWithMessage, url, msg) : MessageFormat.format(JGitText.get().uriNotFound, url);
        return new NoRemoteRepositoryException(u, text);
    }

    private HttpAuthMethod authFromUri(URIish u) {
        String user = u.getUser();
        String pass = u.getPass();
        if (user != null && pass != null) {
            try {
                user = URLDecoder.decode(user.replace("+", "%2B"), StandardCharsets.UTF_8.name());
                pass = URLDecoder.decode(pass.replace("+", "%2B"), StandardCharsets.UTF_8.name());
                HttpAuthMethod basic = HttpAuthMethod.Type.BASIC.method(null);
                basic.authorize(user, pass);
                return basic;
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                LOG.warn(JGitText.get().httpUserInfoDecodeError, (Object)u);
            }
        }
        return HttpAuthMethod.Type.NONE.method(null);
    }

    private HttpConnection connect(String service) throws TransportException, NotSupportedException {
        return this.connect(service, null);
    }

    private HttpConnection connect(String service, TransferConfig.ProtocolVersion protocolVersion) throws TransportException, NotSupportedException {
        URL u = this.getServiceURL(service);
        if (HttpAuthMethod.Type.NONE.equals((Object)this.authMethod.getType())) {
            this.authMethod = this.authFromUri(this.currentUri);
        }
        int authAttempts = 1;
        int redirects = 0;
        HashSet<HttpAuthMethod.Type> ignoreTypes = null;
        while (true) {
            try {
                int status;
                HttpConnection conn;
                block14: while (true) {
                    conn = this.httpOpen("GET", u, AcceptEncoding.GZIP);
                    if (this.useSmartHttp) {
                        String exp = "application/x-" + service + "-advertisement";
                        conn.setRequestProperty("Accept", String.valueOf(exp) + ", */*");
                    } else {
                        conn.setRequestProperty("Accept", "*/*");
                    }
                    if (TransferConfig.ProtocolVersion.V2.equals((Object)protocolVersion)) {
                        conn.setRequestProperty("Git-Protocol", "version=2");
                    }
                    status = HttpSupport.response(conn);
                    this.processResponseCookies(conn);
                    switch (status) {
                        case 200: {
                            if (this.authMethod.getType() == HttpAuthMethod.Type.NONE && conn.getHeaderField("WWW-Authenticate") != null) {
                                this.authMethod = HttpAuthMethod.scanResponse(conn, ignoreTypes);
                            }
                            return conn;
                        }
                        case 404: {
                            throw this.createNotFoundException(this.uri, u, conn.getResponseMessage());
                        }
                        case 401: {
                            this.authMethod = HttpAuthMethod.scanResponse(conn, ignoreTypes);
                            if (this.authMethod.getType() == HttpAuthMethod.Type.NONE) {
                                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().authenticationNotSupported, this.uri));
                            }
                            CredentialsProvider credentialsProvider = this.getCredentialsProvider();
                            if (credentialsProvider == null) {
                                throw new TransportException(this.uri, JGitText.get().noCredentialsProvider);
                            }
                            if (authAttempts > 1) {
                                credentialsProvider.reset(this.currentUri);
                            }
                            if (3 < authAttempts || !this.authMethod.authorize(this.currentUri, credentialsProvider)) {
                                throw new TransportException(this.uri, JGitText.get().notAuthorized);
                            }
                            ++authAttempts;
                            continue block14;
                        }
                        case 403: {
                            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().serviceNotPermitted, this.baseUrl, service));
                        }
                        case 301: 
                        case 302: 
                        case 303: 
                        case 307: 
                        case 308: {
                            if (this.http.getFollowRedirects() == HttpConfig.HttpRedirectMode.FALSE) {
                                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectsOff, status));
                            }
                            URIish newUri = this.redirect(u, conn.getHeaderField("Location"), "info/refs", redirects++);
                            this.setURI(newUri);
                            u = this.getServiceURL(service);
                            authAttempts = 1;
                            continue block14;
                        }
                    }
                    break;
                }
                String err = String.valueOf(status) + " " + conn.getResponseMessage();
                throw new TransportException(this.uri, err);
            }
            catch (NotSupportedException | TransportException e) {
                throw e;
            }
            catch (InterruptedIOException e) {
                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().connectionTimeOut, u.getHost()), e);
            }
            catch (SocketException e) {
                throw new TransportException(this.uri, JGitText.get().connectionFailed, e);
            }
            catch (SSLHandshakeException e) {
                this.handleSslFailure(e);
                continue;
            }
            catch (IOException e) {
                if (this.authMethod.getType() != HttpAuthMethod.Type.NONE) {
                    if (ignoreTypes == null) {
                        ignoreTypes = new HashSet<HttpAuthMethod.Type>();
                    }
                    ignoreTypes.add(this.authMethod.getType());
                    this.authMethod = HttpAuthMethod.Type.NONE.method(null);
                    authAttempts = 1;
                    continue;
                }
                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotOpenService, service), e);
            }
            break;
        }
    }

    void processResponseCookies(HttpConnection conn) {
        if (this.cookieFile != null && this.http.getSaveCookies()) {
            LinkedList<HttpCookie> foundCookies = new LinkedList<HttpCookie>();
            List<String> cookieHeaderValues = conn.getHeaderFields("Set-Cookie");
            if (!cookieHeaderValues.isEmpty()) {
                foundCookies.addAll(this.extractCookies("Set-Cookie", cookieHeaderValues));
            }
            if (!(cookieHeaderValues = conn.getHeaderFields("Set-Cookie2")).isEmpty()) {
                foundCookies.addAll(this.extractCookies("Set-Cookie2", cookieHeaderValues));
            }
            if (!foundCookies.isEmpty()) {
                try {
                    Set<HttpCookie> cookies = this.cookieFile.getCookies(false);
                    cookies.addAll(foundCookies);
                    this.cookieFile.write(this.baseUrl);
                    this.relevantCookies.addAll(foundCookies);
                }
                catch (IOException | IllegalArgumentException | InterruptedException e) {
                    LOG.warn(MessageFormat.format(JGitText.get().couldNotPersistCookies, this.cookieFile.getPath()), (Throwable)e);
                }
            }
        }
    }

    private List<HttpCookie> extractCookies(String headerKey, List<String> headerValues) {
        LinkedList<HttpCookie> foundCookies = new LinkedList<HttpCookie>();
        for (String headerValue : headerValues) {
            foundCookies.addAll(HttpCookie.parse(String.valueOf(headerKey) + ':' + headerValue));
        }
        for (HttpCookie foundCookie : foundCookies) {
            String domain = foundCookie.getDomain();
            if (domain == null || !domain.startsWith(".")) continue;
            foundCookie.setDomain(domain.substring(1));
        }
        return foundCookies;
    }

    private void handleSslFailure(Throwable e) throws TransportException {
        if (this.sslFailure || !this.trustInsecureSslConnection(e.getCause())) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().sslFailureExceptionMessage, this.currentUri.setPass(null)), e);
        }
        this.sslFailure = true;
    }

    private boolean trustInsecureSslConnection(Throwable cause) {
        boolean answered;
        CredentialItems trust;
        CredentialItem[] items;
        CredentialsProvider provider;
        if ((cause instanceof CertificateException || cause instanceof CertPathBuilderException || cause instanceof CertPathValidatorException) && (provider = this.getCredentialsProvider()) != null && provider.supports(items = (trust = this.constructSslTrustItems(cause)).items()) && (answered = provider.get(this.uri, items))) {
            boolean trustNow = trust.now.getValue();
            boolean trustLocal = trust.forRepo != null && trust.forRepo.getValue();
            boolean trustAlways = trust.always.getValue();
            if (trustNow || trustLocal || trustAlways) {
                this.sslVerify = false;
                if (trustAlways) {
                    this.updateSslVerifyUser(false);
                } else if (trustLocal) {
                    this.updateSslVerify(this.local.getConfig(), false);
                }
                return true;
            }
        }
        return false;
    }

    private CredentialItems constructSslTrustItems(Throwable cause) {
        CredentialItems items = new CredentialItems();
        String info = MessageFormat.format(JGitText.get().sslFailureInfo, this.currentUri.setPass(null));
        String sslMessage = cause.getLocalizedMessage();
        if (sslMessage == null) {
            sslMessage = cause.toString();
        }
        sslMessage = MessageFormat.format(JGitText.get().sslFailureCause, sslMessage);
        items.message = new CredentialItem.InformationalMessage(String.valueOf(info) + '\n' + sslMessage + '\n' + JGitText.get().sslFailureTrustExplanation);
        items.now = new CredentialItem.YesNoType(JGitText.get().sslTrustNow);
        if (this.local != null) {
            items.forRepo = new CredentialItem.YesNoType(MessageFormat.format(JGitText.get().sslTrustForRepo, this.local.getDirectory()));
        }
        items.always = new CredentialItem.YesNoType(JGitText.get().sslTrustAlways);
        return items;
    }

    private void updateSslVerify(StoredConfig config, boolean value) {
        String uriPattern = String.valueOf(this.uri.getScheme()) + "://" + this.uri.getHost();
        int port = this.uri.getPort();
        if (port > 0) {
            uriPattern = String.valueOf(uriPattern) + ":" + port;
        }
        config.setBoolean("http", uriPattern, "sslVerify", value);
        try {
            config.save();
        }
        catch (IOException e) {
            LOG.error(JGitText.get().sslVerifyCannotSave, (Throwable)e);
        }
    }

    private void updateSslVerifyUser(boolean value) {
        StoredConfig userConfig = null;
        try {
            userConfig = SystemReader.getInstance().getUserConfig();
            this.updateSslVerify(userConfig, value);
        }
        catch (IOException | ConfigInvalidException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private URIish redirect(URL currentUrl, String location, String checkFor, int redirects) throws TransportException {
        if (location == null || location.isEmpty()) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectLocationMissing, this.baseUrl));
        }
        if (redirects >= this.http.getMaxRedirects()) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectLimitExceeded, this.http.getMaxRedirects(), this.baseUrl, location));
        }
        try {
            URI redirectTo = new URI(location);
            boolean resetAuth = !StringUtils.isEmptyOrNull(redirectTo.getUserInfo());
            String currentHost = currentUrl.getHost();
            redirectTo = currentUrl.toURI().resolve(redirectTo);
            resetAuth = resetAuth || !currentHost.equals(redirectTo.getHost());
            String redirected = redirectTo.toASCIIString();
            if (!this.isValidRedirect(this.baseUrl, redirected, checkFor)) {
                throw new TransportException(this.uri, MessageFormat.format(JGitText.get().redirectBlocked, this.baseUrl, redirected));
            }
            redirected = redirected.substring(0, redirected.indexOf(checkFor));
            URIish result = new URIish(redirected);
            if (resetAuth) {
                this.authMethod = HttpAuthMethod.Type.NONE.method(null);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(JGitText.get().redirectHttp, this.uri.setPass(null), redirects, this.baseUrl, result));
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().invalidRedirectLocation, this.baseUrl, location), e);
        }
    }

    private boolean isValidRedirect(URL current, String next, String checkFor) {
        String oldProtocol = current.getProtocol().toLowerCase(Locale.ROOT);
        int schemeEnd = next.indexOf("://");
        if (schemeEnd < 0) {
            return false;
        }
        String newProtocol = next.substring(0, schemeEnd).toLowerCase(Locale.ROOT);
        if (!oldProtocol.equals(newProtocol) && !"https".equals(newProtocol)) {
            return false;
        }
        return next.contains(checkFor);
    }

    private URL getServiceURL(String service) throws NotSupportedException {
        try {
            StringBuilder b = new StringBuilder();
            b.append(this.baseUrl);
            if (b.charAt(b.length() - 1) != '/') {
                b.append('/');
            }
            b.append("info/refs");
            if (this.useSmartHttp) {
                b.append(b.indexOf("?") < 0 ? (char)'?' : '&');
                b.append("service=");
                b.append(service);
            }
            return new URL(b.toString());
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, this.uri), e);
        }
    }

    protected HttpConnection httpOpen(String method, URL u, AcceptEncoding acceptEncoding) throws IOException {
        if (method == null || u == null || acceptEncoding == null) {
            throw new NullPointerException();
        }
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, u);
        this.factoryUsed = true;
        HttpConnection conn = this.factory.create(u, proxy);
        if (this.gitSession == null && this.factory instanceof HttpConnectionFactory2) {
            this.gitSession = ((HttpConnectionFactory2)this.factory).newSession();
        }
        if (this.gitSession != null) {
            try {
                this.gitSession.configure(conn, this.sslVerify);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
        } else if (!this.sslVerify && "https".equals(u.getProtocol())) {
            HttpSupport.disableSslVerify(conn);
        }
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod(method);
        conn.setUseCaches(false);
        if (acceptEncoding == AcceptEncoding.GZIP) {
            conn.setRequestProperty("Accept-Encoding", "gzip");
        }
        conn.setRequestProperty("Pragma", "no-cache");
        if (this.http.getUserAgent() != null) {
            conn.setRequestProperty("User-Agent", this.http.getUserAgent());
        } else if (UserAgent.get() != null) {
            conn.setRequestProperty("User-Agent", UserAgent.get());
        }
        int timeOut = this.getTimeout();
        if (timeOut != -1) {
            int effTimeOut = timeOut * 1000;
            conn.setConnectTimeout(effTimeOut);
            conn.setReadTimeout(effTimeOut);
        }
        TransportHttp.addHeaders(conn, this.http.getExtraHeaders());
        if (!this.relevantCookies.isEmpty()) {
            this.setCookieHeader(conn);
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        this.authMethod.configureRequest(conn);
        return conn;
    }

    static void addHeaders(HttpConnection conn, List<String> headersToAdd) {
        for (String header : headersToAdd) {
            int colon = header.indexOf(58);
            String key = null;
            if (colon > 0) {
                key = header.substring(0, colon).trim();
            }
            if (key == null || key.isEmpty()) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHeaderFormat, header));
                continue;
            }
            if (HttpSupport.scanToken(key, 0) != key.length()) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHeaderKey, header));
                continue;
            }
            String value = header.substring(colon + 1).trim();
            if (!StandardCharsets.US_ASCII.newEncoder().canEncode(value)) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHeaderValue, header));
                continue;
            }
            conn.setRequestProperty(key, value);
        }
    }

    private void setCookieHeader(HttpConnection conn) {
        StringBuilder cookieHeaderValue = new StringBuilder();
        for (HttpCookie cookie : this.relevantCookies) {
            if (cookie.hasExpired()) continue;
            if (cookieHeaderValue.length() > 0) {
                cookieHeaderValue.append(';');
            }
            cookieHeaderValue.append(cookie.toString());
        }
        if (cookieHeaderValue.length() > 0) {
            conn.setRequestProperty("Cookie", cookieHeaderValue.toString());
        }
    }

    final InputStream openInputStream(HttpConnection conn) throws IOException {
        InputStream input = conn.getInputStream();
        if (this.isGzipContent(conn)) {
            input = new GZIPInputStream(input);
        }
        return input;
    }

    IOException wrongContentType(String expType, String actType) {
        String why = MessageFormat.format(JGitText.get().expectedReceivedContentType, expType, actType);
        return new TransportException(this.uri, why);
    }

    private static NetscapeCookieFile getCookieFileFromConfig(HttpConfig config) {
        if (!StringUtils.isEmptyOrNull(config.getCookieFile())) {
            try {
                Path cookieFilePath = Paths.get(config.getCookieFile(), new String[0]);
                return NetscapeCookieFileCache.getInstance(config).getEntry(cookieFilePath);
            }
            catch (InvalidPathException e) {
                LOG.warn(MessageFormat.format(JGitText.get().couldNotReadCookieFile, config.getCookieFile()), (Throwable)e);
            }
        }
        return null;
    }

    private static Set<HttpCookie> filterCookies(NetscapeCookieFile cookieFile, URL url) {
        if (cookieFile != null) {
            return TransportHttp.filterCookies(cookieFile.getCookies(true), url);
        }
        return Collections.emptySet();
    }

    private static Set<HttpCookie> filterCookies(Set<HttpCookie> allCookies, URL url) {
        HashSet<HttpCookie> filteredCookies = new HashSet<HttpCookie>();
        for (HttpCookie cookie : allCookies) {
            if (cookie.hasExpired() || !TransportHttp.matchesCookieDomain(url.getHost(), cookie.getDomain()) || !TransportHttp.matchesCookiePath(url.getPath(), cookie.getPath()) || cookie.getSecure() && !"https".equals(url.getProtocol())) continue;
            filteredCookies.add(cookie);
        }
        return filteredCookies;
    }

    static boolean matchesCookieDomain(String host, String cookieDomain) {
        cookieDomain = cookieDomain.toLowerCase(Locale.ROOT);
        if ((host = host.toLowerCase(Locale.ROOT)).equals(cookieDomain)) {
            return true;
        }
        if (!host.endsWith(cookieDomain)) {
            return false;
        }
        return host.charAt(host.length() - cookieDomain.length() - 1) == '.';
    }

    static boolean matchesCookiePath(String path, String cookiePath) {
        if (cookiePath.equals(path)) {
            return true;
        }
        if (!cookiePath.endsWith("/")) {
            cookiePath = String.valueOf(cookiePath) + "/";
        }
        return path.startsWith(cookiePath);
    }

    private boolean isSmartHttp(HttpConnection c, String service) {
        String expType = "application/x-" + service + "-advertisement";
        String actType = c.getContentType();
        return expType.equals(actType);
    }

    private boolean isGzipContent(HttpConnection c) {
        return "gzip".equals(c.getHeaderField("Content-Encoding")) || "x-gzip".equals(c.getHeaderField("Content-Encoding"));
    }

    private void readSmartHeaders(InputStream in, String service) throws IOException {
        byte[] magic = new byte[14];
        if (!in.markSupported()) {
            throw new TransportException(this.uri, JGitText.get().inputStreamMustSupportMark);
        }
        in.mark(14);
        IO.readFully(in, magic, 0, magic.length);
        if (Arrays.equals(Arrays.copyOfRange(magic, 4, 11), VERSION) && magic[12] >= 49 && magic[12] <= 57) {
            in.reset();
            return;
        }
        if (magic[4] != 35) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedPktLineWithService, RawParseUtils.decode(magic)));
        }
        in.reset();
        PacketLineIn pckIn = new PacketLineIn(in);
        String exp = "# service=" + service;
        String act = pckIn.readString();
        if (!exp.equals(act)) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedGot, exp, act));
        }
        while (!PacketLineIn.isEnd(pckIn.readString())) {
        }
    }

    public static enum AcceptEncoding {
        UNSPECIFIED,
        GZIP;

    }

    private static class CredentialItems {
        CredentialItem.InformationalMessage message;
        CredentialItem.YesNoType now;
        CredentialItem.YesNoType forRepo;
        CredentialItem.YesNoType always;

        private CredentialItems() {
        }

        public CredentialItem[] items() {
            if (this.forRepo == null) {
                return new CredentialItem[]{this.message, this.now, this.always};
            }
            return new CredentialItem[]{this.message, this.now, this.forRepo, this.always};
        }
    }

    class HttpObjectDB
    extends WalkRemoteObjectDatabase {
        private final URL httpObjectsUrl;

        HttpObjectDB(URL b) {
            this.httpObjectsUrl = b;
        }

        @Override
        URIish getURI() {
            return new URIish(this.httpObjectsUrl);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/http-alternates");
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    return this.readAlternates("info/alternates");
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    return null;
                }
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new HttpObjectDB(new URL(this.httpObjectsUrl, location));
        }

        @Override
        BufferedReader openReader(String path) throws IOException {
            InputStream is = this.open((String)path, (AcceptEncoding)AcceptEncoding.GZIP).in;
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> packs = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader br = this.openReader("info/packs");){
                    String s;
                    while ((s = br.readLine()) != null && s.length() != 0) {
                        if (!s.startsWith("P pack-") || !s.endsWith(".pack")) {
                            throw this.invalidAdvertisement(s);
                        }
                        packs.add(s.substring(2));
                    }
                    return packs;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException err) {
                return packs;
            }
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path) throws IOException {
            return this.open(path, AcceptEncoding.UNSPECIFIED);
        }

        WalkRemoteObjectDatabase.FileStream open(String path, AcceptEncoding acceptEncoding) throws IOException {
            URL base = this.httpObjectsUrl;
            URL u = new URL(base, path);
            HttpConnection c = TransportHttp.this.httpOpen("GET", u, acceptEncoding);
            switch (HttpSupport.response(c)) {
                case 200: {
                    InputStream in = TransportHttp.this.openInputStream(c);
                    if (!TransportHttp.this.isGzipContent(c)) {
                        int len = c.getContentLength();
                        return new WalkRemoteObjectDatabase.FileStream(in, len);
                    }
                    return new WalkRemoteObjectDatabase.FileStream(in);
                }
                case 404: {
                    throw new FileNotFoundException(u.toString());
                }
            }
            throw new IOException(String.valueOf(u.toString()) + ": " + HttpSupport.response(c) + " " + c.getResponseMessage());
        }

        Map<String, Ref> readAdvertisedImpl(BufferedReader br) throws IOException, PackProtocolException {
            String line;
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            while ((line = br.readLine()) != null) {
                Ref prior;
                int tab = line.indexOf(9);
                if (tab < 0) {
                    throw this.invalidAdvertisement(line);
                }
                String name = line.substring(tab + 1);
                ObjectId id = ObjectId.fromString(line.substring(0, tab));
                if (name.endsWith("^{}")) {
                    prior = avail.get(name = name.substring(0, name.length() - 3));
                    if (prior == null) {
                        throw this.outOfOrderAdvertisement(name);
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(String.valueOf(name) + "^{}");
                    }
                    avail.put(name, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, prior.getObjectId(), id));
                    continue;
                }
                prior = avail.put(name, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id));
                if (prior == null) continue;
                throw this.duplicateAdvertisement(name);
            }
            return avail;
        }

        private PackProtocolException outOfOrderAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().advertisementOfCameBefore, n, n));
        }

        private PackProtocolException invalidAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().invalidAdvertisementOf, n));
        }

        private PackProtocolException duplicateAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, n));
        }

        @Override
        void close() {
        }
    }

    class LongPollService
    extends Service {
        LongPollService(String serviceName, TransferConfig.ProtocolVersion protocolVersion) {
            super(serviceName, protocolVersion);
        }

        @Override
        void execute() throws IOException {
            this.out.close();
            if (this.conn == null) {
                this.sendRequest();
            }
            this.openResponse();
            this.in.add(TransportHttp.this.openInputStream(this.conn));
        }
    }

    class MultiRequestService
    extends Service {
        boolean finalRequest;

        MultiRequestService(String serviceName, TransferConfig.ProtocolVersion protocolVersion) {
            super(serviceName, protocolVersion);
        }

        @Override
        void execute() throws IOException {
            this.out.close();
            if (this.conn == null) {
                if (this.out.length() == 0L) {
                    if (this.finalRequest) {
                        return;
                    }
                    throw new TransportException(TransportHttp.this.uri, JGitText.get().startingReadStageWithoutWrittenRequestDataPendingIsNotSupported);
                }
                this.sendRequest();
            }
            this.out.reset();
            this.openResponse();
            this.in.add(TransportHttp.this.openInputStream(this.conn));
            if (!this.finalRequest) {
                this.in.add(this.execute);
            }
            this.conn = null;
        }
    }

    abstract class Service {
        protected final String serviceName;
        protected final String requestType;
        protected final String responseType;
        protected HttpConnection conn;
        protected HttpOutputStream out;
        protected final HttpExecuteStream execute;
        protected final TransferConfig.ProtocolVersion protocolVersion;
        final UnionInputStream in;

        Service(String serviceName, TransferConfig.ProtocolVersion protocolVersion) {
            this.serviceName = serviceName;
            this.protocolVersion = protocolVersion;
            this.requestType = "application/x-" + serviceName + "-request";
            this.responseType = "application/x-" + serviceName + "-result";
            this.out = new HttpOutputStream();
            this.execute = new HttpExecuteStream();
            this.in = new UnionInputStream(this.execute);
        }

        void openStream() throws IOException {
            this.conn = TransportHttp.this.httpOpen("POST", new URL(TransportHttp.this.baseUrl, this.serviceName), AcceptEncoding.GZIP);
            this.conn.setInstanceFollowRedirects(false);
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty("Content-Type", this.requestType);
            this.conn.setRequestProperty("Accept", this.responseType);
            if (TransferConfig.ProtocolVersion.V2.equals((Object)this.protocolVersion)) {
                this.conn.setRequestProperty("Git-Protocol", "version=2");
            }
        }

        void sendRequest() throws IOException {
            TemporaryBuffer buf = new TemporaryBuffer.Heap(TransportHttp.this.http.getPostBuffer());
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (GZIPOutputStream gzip = new GZIPOutputStream(buf);){
                    this.out.writeTo(gzip, null);
                    if (this.out.length() < buf.length()) {
                        buf = this.out;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException err) {
                buf = this.out;
            }
            HttpAuthMethod authenticator = null;
            EnumSet<HttpAuthMethod.Type> ignoreTypes = EnumSet.noneOf(HttpAuthMethod.Type.class);
            int authAttempts = 1;
            int redirects = 0;
            while (true) {
                try {
                    block30: while (true) {
                        this.openStream();
                        if (buf != this.out) {
                            this.conn.setRequestProperty("Content-Encoding", "gzip");
                        }
                        this.conn.setFixedLengthStreamingMode((int)buf.length());
                        Throwable throwable = null;
                        Object var7_17 = null;
                        try (OutputStream httpOut = this.conn.getOutputStream();){
                            buf.writeTo(httpOut, null);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        int status = HttpSupport.response(this.conn);
                        switch (status) {
                            case 200: {
                                return;
                            }
                            case 404: {
                                throw TransportHttp.this.createNotFoundException(TransportHttp.this.uri, this.conn.getURL(), this.conn.getResponseMessage());
                            }
                            case 403: {
                                throw new TransportException(TransportHttp.this.uri, MessageFormat.format(JGitText.get().serviceNotPermitted, TransportHttp.this.baseUrl, this.serviceName));
                            }
                            case 301: 
                            case 302: 
                            case 307: 
                            case 308: {
                                if (TransportHttp.this.http.getFollowRedirects() != HttpConfig.HttpRedirectMode.TRUE) {
                                    return;
                                }
                                TransportHttp.this.currentUri = TransportHttp.this.redirect(this.conn.getURL(), this.conn.getHeaderField("Location"), String.valueOf('/') + this.serviceName, redirects++);
                                try {
                                    TransportHttp.this.baseUrl = TransportHttp.this.toURL(TransportHttp.this.currentUri);
                                    continue block30;
                                }
                                catch (MalformedURLException e) {
                                    throw new TransportException(TransportHttp.this.uri, MessageFormat.format(JGitText.get().invalidRedirectLocation, TransportHttp.this.baseUrl, TransportHttp.this.currentUri), e);
                                }
                            }
                            case 401: {
                                HttpAuthMethod nextMethod = HttpAuthMethod.scanResponse(this.conn, ignoreTypes);
                                switch (nextMethod.getType()) {
                                    case NONE: {
                                        throw new TransportException(TransportHttp.this.uri, MessageFormat.format(JGitText.get().authenticationNotSupported, this.conn.getURL()));
                                    }
                                    case NEGOTIATE: {
                                        ignoreTypes.add(HttpAuthMethod.Type.NEGOTIATE);
                                        if (authenticator != null) {
                                            ignoreTypes.add(authenticator.getType());
                                        }
                                        authAttempts = 1;
                                        break;
                                    }
                                    default: {
                                        ignoreTypes.add(HttpAuthMethod.Type.NEGOTIATE);
                                        if (authenticator != null && authenticator.getType() == nextMethod.getType()) break;
                                        if (authenticator != null) {
                                            ignoreTypes.add(authenticator.getType());
                                        }
                                        authAttempts = 1;
                                    }
                                }
                                TransportHttp.this.authMethod = nextMethod;
                                authenticator = nextMethod;
                                CredentialsProvider credentialsProvider = TransportHttp.this.getCredentialsProvider();
                                if (credentialsProvider == null) {
                                    throw new TransportException(TransportHttp.this.uri, JGitText.get().noCredentialsProvider);
                                }
                                if (authAttempts > 1) {
                                    credentialsProvider.reset(TransportHttp.this.currentUri);
                                }
                                if (3 < authAttempts || !TransportHttp.this.authMethod.authorize(TransportHttp.this.currentUri, credentialsProvider)) {
                                    throw new TransportException(TransportHttp.this.uri, JGitText.get().notAuthorized);
                                }
                                ++authAttempts;
                                continue block30;
                            }
                        }
                        break;
                    }
                    return;
                }
                catch (SSLHandshakeException e) {
                    TransportHttp.this.handleSslFailure(e);
                    continue;
                }
                catch (InterruptedIOException | SocketException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (authenticator == null || TransportHttp.this.authMethod.getType() != HttpAuthMethod.Type.NONE) {
                        if (TransportHttp.this.authMethod.getType() != HttpAuthMethod.Type.NONE) {
                            ignoreTypes.add(TransportHttp.this.authMethod.getType());
                        }
                        TransportHttp.this.authMethod = HttpAuthMethod.Type.NONE.method(null);
                        authenticator = TransportHttp.this.authMethod;
                        authAttempts = 1;
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        void openResponse() throws IOException {
            int status = HttpSupport.response(this.conn);
            if (status != 200) {
                throw new TransportException(TransportHttp.this.uri, String.valueOf(status) + " " + this.conn.getResponseMessage());
            }
            String contentType = this.conn.getContentType();
            if (!this.responseType.equals(contentType)) {
                this.conn.getInputStream().close();
                throw TransportHttp.this.wrongContentType(this.responseType, contentType);
            }
        }

        HttpOutputStream getOutputStream() {
            return this.out;
        }

        InputStream getInputStream() {
            return this.in;
        }

        abstract void execute() throws IOException;

        class HttpExecuteStream
        extends InputStream {
            HttpExecuteStream() {
            }

            @Override
            public int read() throws IOException {
                Service.this.execute();
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Service.this.execute();
                return -1;
            }

            @Override
            public long skip(long n) throws IOException {
                Service.this.execute();
                return 0L;
            }
        }

        class HttpOutputStream
        extends TemporaryBuffer {
            HttpOutputStream() {
                super(TransportHttp.this.http.getPostBuffer());
            }

            @Override
            protected OutputStream overflow() throws IOException {
                Service.this.openStream();
                Service.this.conn.setChunkedStreamingMode(0);
                return Service.this.conn.getOutputStream();
            }
        }
    }

    class SmartHttpFetchConnection
    extends BasePackFetchConnection {
        private MultiRequestService svc;

        SmartHttpFetchConnection(InputStream advertisement) throws TransportException {
            this(advertisement, Collections.emptyList(), new String[0]);
        }

        SmartHttpFetchConnection(InputStream advertisement, Collection<RefSpec> refSpecs, String ... additionalPatterns) throws TransportException {
            super(TransportHttp.this);
            this.statelessRPC = true;
            this.init(advertisement, DisabledOutputStream.INSTANCE);
            this.outNeedsEnd = false;
            if (!this.readAdvertisedRefs()) {
                LongPollService service = new LongPollService(TransportHttp.SVC_UPLOAD_PACK, this.getProtocolVersion());
                this.init(service.getInputStream(), service.getOutputStream());
                this.lsRefs(refSpecs, additionalPatterns);
            }
        }

        @Override
        protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have, OutputStream outputStream) throws TransportException {
            try {
                this.svc = new MultiRequestService(TransportHttp.SVC_UPLOAD_PACK, this.getProtocolVersion());
                this.init(this.svc.getInputStream(), this.svc.getOutputStream());
                super.doFetch(monitor, want, have, outputStream);
            }
            finally {
                this.svc = null;
            }
        }

        @Override
        protected void onReceivePack() {
            this.svc.finalRequest = true;
        }
    }

    class SmartHttpPushConnection
    extends BasePackPushConnection {
        SmartHttpPushConnection(InputStream advertisement) throws TransportException {
            super(TransportHttp.this);
            this.statelessRPC = true;
            this.init(advertisement, DisabledOutputStream.INSTANCE);
            this.outNeedsEnd = false;
            this.readAdvertisedRefs();
        }

        @Override
        protected void doPush(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream outputStream) throws TransportException {
            MultiRequestService svc = new MultiRequestService(TransportHttp.SVC_RECEIVE_PACK, this.getProtocolVersion());
            this.init(svc.getInputStream(), svc.getOutputStream());
            super.doPush(monitor, refUpdates, outputStream);
        }
    }
}

